<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelItinerary Structs
 * @subpackage Structs
 */
class TravelItinerary extends AbstractStructBase
{
    /**
     * The AccountingInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\AccountingInfo[]
     */
    public $AccountingInfo;
    /**
     * The CustomerInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\CustomerInfo
     */
    public $CustomerInfo;
    /**
     * The FileInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\FileInfo
     */
    public $FileInfo;
    /**
     * The ItineraryInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\ItineraryInfo
     */
    public $ItineraryInfo;
    /**
     * The ItineraryRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\ItineraryRef
     */
    public $ItineraryRef;
    /**
     * The PayInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\PayInfo[]
     */
    public $PayInfo;
    /**
     * The QueueInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\QueueInfo
     */
    public $QueueInfo;
    /**
     * The RemarkInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\RemarkInfo
     */
    public $RemarkInfo;
    /**
     * The SpecialServiceInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\SpecialServiceInfo[]
     */
    public $SpecialServiceInfo;
    /**
     * The OpenReservationElements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\OpenReservationElements
     */
    public $OpenReservationElements;
    /**
     * The CorporateIDInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\CorporateIDInfo[]
     */
    public $CorporateIDInfo;
    /**
     * Constructor method for TravelItinerary
     * @uses TravelItinerary::setAccountingInfo()
     * @uses TravelItinerary::setCustomerInfo()
     * @uses TravelItinerary::setFileInfo()
     * @uses TravelItinerary::setItineraryInfo()
     * @uses TravelItinerary::setItineraryRef()
     * @uses TravelItinerary::setPayInfo()
     * @uses TravelItinerary::setQueueInfo()
     * @uses TravelItinerary::setRemarkInfo()
     * @uses TravelItinerary::setSpecialServiceInfo()
     * @uses TravelItinerary::setOpenReservationElements()
     * @uses TravelItinerary::setCorporateIDInfo()
     * @param \Sabre\PassengerDetailsRQ\Structs\AccountingInfo[] $accountingInfo
     * @param \Sabre\PassengerDetailsRQ\Structs\CustomerInfo $customerInfo
     * @param \Sabre\PassengerDetailsRQ\Structs\FileInfo $fileInfo
     * @param \Sabre\PassengerDetailsRQ\Structs\ItineraryInfo $itineraryInfo
     * @param \Sabre\PassengerDetailsRQ\Structs\ItineraryRef $itineraryRef
     * @param \Sabre\PassengerDetailsRQ\Structs\PayInfo[] $payInfo
     * @param \Sabre\PassengerDetailsRQ\Structs\QueueInfo $queueInfo
     * @param \Sabre\PassengerDetailsRQ\Structs\RemarkInfo $remarkInfo
     * @param \Sabre\PassengerDetailsRQ\Structs\SpecialServiceInfo[] $specialServiceInfo
     * @param \Sabre\PassengerDetailsRQ\Structs\OpenReservationElements $openReservationElements
     * @param \Sabre\PassengerDetailsRQ\Structs\CorporateIDInfo[] $corporateIDInfo
     */
    public function __construct(array $accountingInfo = array(), \Sabre\PassengerDetailsRQ\Structs\CustomerInfo $customerInfo = null, \Sabre\PassengerDetailsRQ\Structs\FileInfo $fileInfo = null, \Sabre\PassengerDetailsRQ\Structs\ItineraryInfo $itineraryInfo = null, \Sabre\PassengerDetailsRQ\Structs\ItineraryRef $itineraryRef = null, array $payInfo = array(), \Sabre\PassengerDetailsRQ\Structs\QueueInfo $queueInfo = null, \Sabre\PassengerDetailsRQ\Structs\RemarkInfo $remarkInfo = null, array $specialServiceInfo = array(), \Sabre\PassengerDetailsRQ\Structs\OpenReservationElements $openReservationElements = null, array $corporateIDInfo = array())
    {
        $this
            ->setAccountingInfo($accountingInfo)
            ->setCustomerInfo($customerInfo)
            ->setFileInfo($fileInfo)
            ->setItineraryInfo($itineraryInfo)
            ->setItineraryRef($itineraryRef)
            ->setPayInfo($payInfo)
            ->setQueueInfo($queueInfo)
            ->setRemarkInfo($remarkInfo)
            ->setSpecialServiceInfo($specialServiceInfo)
            ->setOpenReservationElements($openReservationElements)
            ->setCorporateIDInfo($corporateIDInfo);
    }
    /**
     * Get AccountingInfo value
     * @return \Sabre\PassengerDetailsRQ\Structs\AccountingInfo[]|null
     */
    public function getAccountingInfo()
    {
        return $this->AccountingInfo;
    }
    /**
     * Set AccountingInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\AccountingInfo[] $accountingInfo
     * @return \Sabre\PassengerDetailsRQ\Structs\TravelItinerary
     */
    public function setAccountingInfo(array $accountingInfo = array())
    {
        $this->AccountingInfo = $accountingInfo;
        return $this;
    }
    /**
     * Add item to AccountingInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\AccountingInfo $item
     * @return \Sabre\PassengerDetailsRQ\Structs\TravelItinerary
     */
    public function addToAccountingInfo(\Sabre\PassengerDetailsRQ\Structs\AccountingInfo $item)
    {
        $this->AccountingInfo[] = $item;
        return $this;
    }
    /**
     * Get CustomerInfo value
     * @return \Sabre\PassengerDetailsRQ\Structs\CustomerInfo|null
     */
    public function getCustomerInfo()
    {
        return $this->CustomerInfo;
    }
    /**
     * Set CustomerInfo value
     * @param \Sabre\PassengerDetailsRQ\Structs\CustomerInfo $customerInfo
     * @return \Sabre\PassengerDetailsRQ\Structs\TravelItinerary
     */
    public function setCustomerInfo(\Sabre\PassengerDetailsRQ\Structs\CustomerInfo $customerInfo = null)
    {
        $this->CustomerInfo = $customerInfo;
        return $this;
    }
    /**
     * Get FileInfo value
     * @return \Sabre\PassengerDetailsRQ\Structs\FileInfo|null
     */
    public function getFileInfo()
    {
        return $this->FileInfo;
    }
    /**
     * Set FileInfo value
     * @param \Sabre\PassengerDetailsRQ\Structs\FileInfo $fileInfo
     * @return \Sabre\PassengerDetailsRQ\Structs\TravelItinerary
     */
    public function setFileInfo(\Sabre\PassengerDetailsRQ\Structs\FileInfo $fileInfo = null)
    {
        $this->FileInfo = $fileInfo;
        return $this;
    }
    /**
     * Get ItineraryInfo value
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryInfo|null
     */
    public function getItineraryInfo()
    {
        return $this->ItineraryInfo;
    }
    /**
     * Set ItineraryInfo value
     * @param \Sabre\PassengerDetailsRQ\Structs\ItineraryInfo $itineraryInfo
     * @return \Sabre\PassengerDetailsRQ\Structs\TravelItinerary
     */
    public function setItineraryInfo(\Sabre\PassengerDetailsRQ\Structs\ItineraryInfo $itineraryInfo = null)
    {
        $this->ItineraryInfo = $itineraryInfo;
        return $this;
    }
    /**
     * Get ItineraryRef value
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryRef|null
     */
    public function getItineraryRef()
    {
        return $this->ItineraryRef;
    }
    /**
     * Set ItineraryRef value
     * @param \Sabre\PassengerDetailsRQ\Structs\ItineraryRef $itineraryRef
     * @return \Sabre\PassengerDetailsRQ\Structs\TravelItinerary
     */
    public function setItineraryRef(\Sabre\PassengerDetailsRQ\Structs\ItineraryRef $itineraryRef = null)
    {
        $this->ItineraryRef = $itineraryRef;
        return $this;
    }
    /**
     * Get PayInfo value
     * @return \Sabre\PassengerDetailsRQ\Structs\PayInfo[]|null
     */
    public function getPayInfo()
    {
        return $this->PayInfo;
    }
    /**
     * Set PayInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\PayInfo[] $payInfo
     * @return \Sabre\PassengerDetailsRQ\Structs\TravelItinerary
     */
    public function setPayInfo(array $payInfo = array())
    {
        $this->PayInfo = $payInfo;
        return $this;
    }
    /**
     * Add item to PayInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\PayInfo $item
     * @return \Sabre\PassengerDetailsRQ\Structs\TravelItinerary
     */
    public function addToPayInfo(\Sabre\PassengerDetailsRQ\Structs\PayInfo $item)
    {
        $this->PayInfo[] = $item;
        return $this;
    }
    /**
     * Get QueueInfo value
     * @return \Sabre\PassengerDetailsRQ\Structs\QueueInfo|null
     */
    public function getQueueInfo()
    {
        return $this->QueueInfo;
    }
    /**
     * Set QueueInfo value
     * @param \Sabre\PassengerDetailsRQ\Structs\QueueInfo $queueInfo
     * @return \Sabre\PassengerDetailsRQ\Structs\TravelItinerary
     */
    public function setQueueInfo(\Sabre\PassengerDetailsRQ\Structs\QueueInfo $queueInfo = null)
    {
        $this->QueueInfo = $queueInfo;
        return $this;
    }
    /**
     * Get RemarkInfo value
     * @return \Sabre\PassengerDetailsRQ\Structs\RemarkInfo|null
     */
    public function getRemarkInfo()
    {
        return $this->RemarkInfo;
    }
    /**
     * Set RemarkInfo value
     * @param \Sabre\PassengerDetailsRQ\Structs\RemarkInfo $remarkInfo
     * @return \Sabre\PassengerDetailsRQ\Structs\TravelItinerary
     */
    public function setRemarkInfo(\Sabre\PassengerDetailsRQ\Structs\RemarkInfo $remarkInfo = null)
    {
        $this->RemarkInfo = $remarkInfo;
        return $this;
    }
    /**
     * Get SpecialServiceInfo value
     * @return \Sabre\PassengerDetailsRQ\Structs\SpecialServiceInfo[]|null
     */
    public function getSpecialServiceInfo()
    {
        return $this->SpecialServiceInfo;
    }
    /**
     * Set SpecialServiceInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\SpecialServiceInfo[] $specialServiceInfo
     * @return \Sabre\PassengerDetailsRQ\Structs\TravelItinerary
     */
    public function setSpecialServiceInfo(array $specialServiceInfo = array())
    {
        $this->SpecialServiceInfo = $specialServiceInfo;
        return $this;
    }
    /**
     * Add item to SpecialServiceInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\SpecialServiceInfo $item
     * @return \Sabre\PassengerDetailsRQ\Structs\TravelItinerary
     */
    public function addToSpecialServiceInfo(\Sabre\PassengerDetailsRQ\Structs\SpecialServiceInfo $item)
    {
        $this->SpecialServiceInfo[] = $item;
        return $this;
    }
    /**
     * Get OpenReservationElements value
     * @return \Sabre\PassengerDetailsRQ\Structs\OpenReservationElements|null
     */
    public function getOpenReservationElements()
    {
        return $this->OpenReservationElements;
    }
    /**
     * Set OpenReservationElements value
     * @param \Sabre\PassengerDetailsRQ\Structs\OpenReservationElements $openReservationElements
     * @return \Sabre\PassengerDetailsRQ\Structs\TravelItinerary
     */
    public function setOpenReservationElements(\Sabre\PassengerDetailsRQ\Structs\OpenReservationElements $openReservationElements = null)
    {
        $this->OpenReservationElements = $openReservationElements;
        return $this;
    }
    /**
     * Get CorporateIDInfo value
     * @return \Sabre\PassengerDetailsRQ\Structs\CorporateIDInfo[]|null
     */
    public function getCorporateIDInfo()
    {
        return $this->CorporateIDInfo;
    }
    /**
     * Set CorporateIDInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\CorporateIDInfo[] $corporateIDInfo
     * @return \Sabre\PassengerDetailsRQ\Structs\TravelItinerary
     */
    public function setCorporateIDInfo(array $corporateIDInfo = array())
    {
        $this->CorporateIDInfo = $corporateIDInfo;
        return $this;
    }
    /**
     * Add item to CorporateIDInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\CorporateIDInfo $item
     * @return \Sabre\PassengerDetailsRQ\Structs\TravelItinerary
     */
    public function addToCorporateIDInfo(\Sabre\PassengerDetailsRQ\Structs\CorporateIDInfo $item)
    {
        $this->CorporateIDInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\TravelItinerary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
