<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing Structs
 * @subpackage Structs
 */
class Ticketing extends AbstractStructBase
{
    /**
     * The TicketType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $TicketType;
    /**
     * The PseudoCityCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The QueueNumber
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $QueueNumber;
    /**
     * The QueueName
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $QueueName;
    /**
     * The ShortText
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ShortText;
    /**
     * The TicketTimeLimit
     * Meta informations extracted from the WSDL
     * - documentation: "TicketTimeLimit" is used to return the ticket time limit-related information. | A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss",
     * "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - use: optional
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $TicketTimeLimit;
    /**
     * The ConjunctedCount
     * Meta informations extracted from the WSDL
     * - documentation: "ConjunctedCount" is used to return the number of conjuncted eTicket coupons associated with the particular accounting line if applicable.
     * - use: optional
     * @var string
     */
    public $ConjunctedCount;
    /**
     * The CouponCount
     * Meta informations extracted from the WSDL
     * - documentation: "CouponCount" is used to return the number of eTicket coupons associated with the particular accounting line if applicable.
     * - use: optional
     * @var string
     */
    public $CouponCount;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\PersonName
     */
    public $PersonName;
    /**
     * The eTicketNumber
     * Meta informations extracted from the WSDL
     * - documentation: "eTicketNumber" is used to return ticket-related information.
     * - use: optional
     * @var string
     */
    public $eTicketNumber;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - documentation: "RPH" is used as a reference place holder.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for Ticketing
     * @uses Ticketing::setTicketType()
     * @uses Ticketing::setPseudoCityCode()
     * @uses Ticketing::setQueueNumber()
     * @uses Ticketing::setQueueName()
     * @uses Ticketing::setShortText()
     * @uses Ticketing::setTicketTimeLimit()
     * @uses Ticketing::setConjunctedCount()
     * @uses Ticketing::setCouponCount()
     * @uses Ticketing::setPersonName()
     * @uses Ticketing::setETicketNumber()
     * @uses Ticketing::setRPH()
     * @uses Ticketing::setId()
     * @param string $ticketType
     * @param string $pseudoCityCode
     * @param int $queueNumber
     * @param string $queueName
     * @param string $shortText
     * @param string $ticketTimeLimit
     * @param string $conjunctedCount
     * @param string $couponCount
     * @param \Sabre\PassengerDetailsRQ\Structs\PersonName $personName
     * @param string $eTicketNumber
     * @param string $rPH
     * @param string $id
     */
    public function __construct($ticketType = null, $pseudoCityCode = null, $queueNumber = null, $queueName = null, $shortText = null, $ticketTimeLimit = null, $conjunctedCount = null, $couponCount = null, \Sabre\PassengerDetailsRQ\Structs\PersonName $personName = null, $eTicketNumber = null, $rPH = null, $id = null)
    {
        $this
            ->setTicketType($ticketType)
            ->setPseudoCityCode($pseudoCityCode)
            ->setQueueNumber($queueNumber)
            ->setQueueName($queueName)
            ->setShortText($shortText)
            ->setTicketTimeLimit($ticketTimeLimit)
            ->setConjunctedCount($conjunctedCount)
            ->setCouponCount($couponCount)
            ->setPersonName($personName)
            ->setETicketNumber($eTicketNumber)
            ->setRPH($rPH)
            ->setId($id);
    }
    /**
     * Get TicketType value
     * @return string
     */
    public function getTicketType()
    {
        return $this->TicketType;
    }
    /**
     * Set TicketType value
     * @param string $ticketType
     * @return \Sabre\PassengerDetailsRQ\Structs\Ticketing
     */
    public function setTicketType($ticketType = null)
    {
        $this->TicketType = $ticketType;
        return $this;
    }
    /**
     * Get PseudoCityCode value
     * @return string|null
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \Sabre\PassengerDetailsRQ\Structs\Ticketing
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get QueueNumber value
     * @return int|null
     */
    public function getQueueNumber()
    {
        return $this->QueueNumber;
    }
    /**
     * Set QueueNumber value
     * @param int $queueNumber
     * @return \Sabre\PassengerDetailsRQ\Structs\Ticketing
     */
    public function setQueueNumber($queueNumber = null)
    {
        $this->QueueNumber = $queueNumber;
        return $this;
    }
    /**
     * Get QueueName value
     * @return string|null
     */
    public function getQueueName()
    {
        return $this->QueueName;
    }
    /**
     * Set QueueName value
     * @param string $queueName
     * @return \Sabre\PassengerDetailsRQ\Structs\Ticketing
     */
    public function setQueueName($queueName = null)
    {
        $this->QueueName = $queueName;
        return $this;
    }
    /**
     * Get ShortText value
     * @return string|null
     */
    public function getShortText()
    {
        return $this->ShortText;
    }
    /**
     * Set ShortText value
     * @param string $shortText
     * @return \Sabre\PassengerDetailsRQ\Structs\Ticketing
     */
    public function setShortText($shortText = null)
    {
        $this->ShortText = $shortText;
        return $this;
    }
    /**
     * Get TicketTimeLimit value
     * @return string|null
     */
    public function getTicketTimeLimit()
    {
        return $this->TicketTimeLimit;
    }
    /**
     * Set TicketTimeLimit value
     * @param string $ticketTimeLimit
     * @return \Sabre\PassengerDetailsRQ\Structs\Ticketing
     */
    public function setTicketTimeLimit($ticketTimeLimit = null)
    {
        $this->TicketTimeLimit = $ticketTimeLimit;
        return $this;
    }
    /**
     * Get ConjunctedCount value
     * @return string|null
     */
    public function getConjunctedCount()
    {
        return $this->ConjunctedCount;
    }
    /**
     * Set ConjunctedCount value
     * @param string $conjunctedCount
     * @return \Sabre\PassengerDetailsRQ\Structs\Ticketing
     */
    public function setConjunctedCount($conjunctedCount = null)
    {
        $this->ConjunctedCount = $conjunctedCount;
        return $this;
    }
    /**
     * Get CouponCount value
     * @return string|null
     */
    public function getCouponCount()
    {
        return $this->CouponCount;
    }
    /**
     * Set CouponCount value
     * @param string $couponCount
     * @return \Sabre\PassengerDetailsRQ\Structs\Ticketing
     */
    public function setCouponCount($couponCount = null)
    {
        $this->CouponCount = $couponCount;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \Sabre\PassengerDetailsRQ\Structs\PersonName|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \Sabre\PassengerDetailsRQ\Structs\PersonName $personName
     * @return \Sabre\PassengerDetailsRQ\Structs\Ticketing
     */
    public function setPersonName(\Sabre\PassengerDetailsRQ\Structs\PersonName $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get eTicketNumber value
     * @return string|null
     */
    public function getETicketNumber()
    {
        return $this->eTicketNumber;
    }
    /**
     * Set eTicketNumber value
     * @param string $eTicketNumber
     * @return \Sabre\PassengerDetailsRQ\Structs\Ticketing
     */
    public function setETicketNumber($eTicketNumber = null)
    {
        $this->eTicketNumber = $eTicketNumber;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\PassengerDetailsRQ\Structs\Ticketing
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\PassengerDetailsRQ\Structs\Ticketing
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\Ticketing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
