<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketCouponNumberAssociation Structs
 * Meta informations extracted from the WSDL
 * - documentation: "TicketCouponNumberAssociation" indicates Etkt coupon number to which the EMD is associated.
 * @subpackage Structs
 */
class TicketCouponNumberAssociation extends AbstractStructBase
{
    /**
     * The TicketCouponNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 16
     * - minOccurs: 0
     * @var int[]
     */
    public $TicketCouponNumber;
    /**
     * The TicketReferenceNumber
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TicketReferenceNumber;
    /**
     * Constructor method for TicketCouponNumberAssociation
     * @uses TicketCouponNumberAssociation::setTicketCouponNumber()
     * @uses TicketCouponNumberAssociation::setTicketReferenceNumber()
     * @param int[] $ticketCouponNumber
     * @param string $ticketReferenceNumber
     */
    public function __construct(array $ticketCouponNumber = array(), $ticketReferenceNumber = null)
    {
        $this
            ->setTicketCouponNumber($ticketCouponNumber)
            ->setTicketReferenceNumber($ticketReferenceNumber);
    }
    /**
     * Get TicketCouponNumber value
     * @return int[]|null
     */
    public function getTicketCouponNumber()
    {
        return $this->TicketCouponNumber;
    }
    /**
     * Set TicketCouponNumber value
     * @throws \InvalidArgumentException
     * @param int[] $ticketCouponNumber
     * @return \Sabre\PassengerDetailsRQ\Structs\TicketCouponNumberAssociation
     */
    public function setTicketCouponNumber(array $ticketCouponNumber = array())
    {
        $this->TicketCouponNumber = $ticketCouponNumber;
        return $this;
    }
    /**
     * Add item to TicketCouponNumber value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \Sabre\PassengerDetailsRQ\Structs\TicketCouponNumberAssociation
     */
    public function addToTicketCouponNumber($item)
    {
        $this->TicketCouponNumber[] = $item;
        return $this;
    }
    /**
     * Get TicketReferenceNumber value
     * @return string|null
     */
    public function getTicketReferenceNumber()
    {
        return $this->TicketReferenceNumber;
    }
    /**
     * Set TicketReferenceNumber value
     * @param string $ticketReferenceNumber
     * @return \Sabre\PassengerDetailsRQ\Structs\TicketCouponNumberAssociation
     */
    public function setTicketReferenceNumber($ticketReferenceNumber = null)
    {
        $this->TicketReferenceNumber = $ticketReferenceNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\TicketCouponNumberAssociation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
