<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Service Structs
 * @subpackage Structs
 */
class Service extends AbstractStructBase
{
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\PersonName[]
     */
    public $PersonName;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: "Text" is used to return miscellaneous SSR-related free text if applicable
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Text;
    /**
     * The VendorPrefs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\VendorPrefs
     */
    public $VendorPrefs;
    /**
     * The SegmentNumber
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SegmentNumber;
    /**
     * The SSR_Code
     * Meta informations extracted from the WSDL
     * - documentation: "SSR_Code is used to return the SSR code associated with the particular SSR segment
     * - use: optional
     * @var string
     */
    public $SSR_Code;
    /**
     * The Airline
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Airline
     */
    public $Airline;
    /**
     * The SSR_Type
     * Meta informations extracted from the WSDL
     * - documentation: "SSR_Type" is used to return the SSR type associated with the particular SSR segment Example: WCHR
     * - use: optional
     * @var string
     */
    public $SSR_Type;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - minLength: 1
     * @var string
     */
    public $type;
    /**
     * Constructor method for Service
     * @uses Service::setPersonName()
     * @uses Service::setText()
     * @uses Service::setVendorPrefs()
     * @uses Service::setSegmentNumber()
     * @uses Service::setSSR_Code()
     * @uses Service::setAirline()
     * @uses Service::setSSR_Type()
     * @uses Service::set_()
     * @uses Service::setType()
     * @param \Sabre\PassengerDetailsRQ\Structs\PersonName[] $personName
     * @param string[] $text
     * @param \Sabre\PassengerDetailsRQ\Structs\VendorPrefs $vendorPrefs
     * @param string $segmentNumber
     * @param string $sSR_Code
     * @param \Sabre\PassengerDetailsRQ\Structs\Airline $airline
     * @param string $sSR_Type
     * @param string $_
     * @param string $type
     */
    public function __construct(array $personName = array(), array $text = array(), \Sabre\PassengerDetailsRQ\Structs\VendorPrefs $vendorPrefs = null, $segmentNumber = null, $sSR_Code = null, \Sabre\PassengerDetailsRQ\Structs\Airline $airline = null, $sSR_Type = null, $_ = null, $type = null)
    {
        $this
            ->setPersonName($personName)
            ->setText($text)
            ->setVendorPrefs($vendorPrefs)
            ->setSegmentNumber($segmentNumber)
            ->setSSR_Code($sSR_Code)
            ->setAirline($airline)
            ->setSSR_Type($sSR_Type)
            ->set_($_)
            ->setType($type);
    }
    /**
     * Get PersonName value
     * @return \Sabre\PassengerDetailsRQ\Structs\PersonName[]|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\PersonName[] $personName
     * @return \Sabre\PassengerDetailsRQ\Structs\Service
     */
    public function setPersonName(array $personName = array())
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Add item to PersonName value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\PersonName $item
     * @return \Sabre\PassengerDetailsRQ\Structs\Service
     */
    public function addToPersonName(\Sabre\PassengerDetailsRQ\Structs\PersonName $item)
    {
        $this->PersonName[] = $item;
        return $this;
    }
    /**
     * Get Text value
     * @return string[]|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @throws \InvalidArgumentException
     * @param string[] $text
     * @return \Sabre\PassengerDetailsRQ\Structs\Service
     */
    public function setText(array $text = array())
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Add item to Text value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\PassengerDetailsRQ\Structs\Service
     */
    public function addToText($item)
    {
        $this->Text[] = $item;
        return $this;
    }
    /**
     * Get VendorPrefs value
     * @return \Sabre\PassengerDetailsRQ\Structs\VendorPrefs|null
     */
    public function getVendorPrefs()
    {
        return $this->VendorPrefs;
    }
    /**
     * Set VendorPrefs value
     * @param \Sabre\PassengerDetailsRQ\Structs\VendorPrefs $vendorPrefs
     * @return \Sabre\PassengerDetailsRQ\Structs\Service
     */
    public function setVendorPrefs(\Sabre\PassengerDetailsRQ\Structs\VendorPrefs $vendorPrefs = null)
    {
        $this->VendorPrefs = $vendorPrefs;
        return $this;
    }
    /**
     * Get SegmentNumber value
     * @return string|null
     */
    public function getSegmentNumber()
    {
        return $this->SegmentNumber;
    }
    /**
     * Set SegmentNumber value
     * @param string $segmentNumber
     * @return \Sabre\PassengerDetailsRQ\Structs\Service
     */
    public function setSegmentNumber($segmentNumber = null)
    {
        $this->SegmentNumber = $segmentNumber;
        return $this;
    }
    /**
     * Get SSR_Code value
     * @return string|null
     */
    public function getSSR_Code()
    {
        return $this->SSR_Code;
    }
    /**
     * Set SSR_Code value
     * @param string $sSR_Code
     * @return \Sabre\PassengerDetailsRQ\Structs\Service
     */
    public function setSSR_Code($sSR_Code = null)
    {
        $this->SSR_Code = $sSR_Code;
        return $this;
    }
    /**
     * Get Airline value
     * @return \Sabre\PassengerDetailsRQ\Structs\Airline|null
     */
    public function getAirline()
    {
        return $this->Airline;
    }
    /**
     * Set Airline value
     * @param \Sabre\PassengerDetailsRQ\Structs\Airline $airline
     * @return \Sabre\PassengerDetailsRQ\Structs\Service
     */
    public function setAirline(\Sabre\PassengerDetailsRQ\Structs\Airline $airline = null)
    {
        $this->Airline = $airline;
        return $this;
    }
    /**
     * Get SSR_Type value
     * @return string|null
     */
    public function getSSR_Type()
    {
        return $this->SSR_Type;
    }
    /**
     * Set SSR_Type value
     * @param string $sSR_Type
     * @return \Sabre\PassengerDetailsRQ\Structs\Service
     */
    public function setSSR_Type($sSR_Type = null)
    {
        $this->SSR_Type = $sSR_Type;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\PassengerDetailsRQ\Structs\Service
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \Sabre\PassengerDetailsRQ\Structs\Service
     */
    public function setType($type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\Service
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
