<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SecureFlight Structs
 * @subpackage Structs
 */
class SecureFlight extends AbstractStructBase
{
    /**
     * The KnownTravelerNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $KnownTravelerNumber;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\PersonName
     */
    public $PersonName;
    /**
     * The RedressNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RedressNumber;
    /**
     * The VendorPrefs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\VendorPrefs
     */
    public $VendorPrefs;
    /**
     * The SegmentNumber
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SegmentNumber;
    /**
     * Constructor method for SecureFlight
     * @uses SecureFlight::setKnownTravelerNumber()
     * @uses SecureFlight::setPersonName()
     * @uses SecureFlight::setRedressNumber()
     * @uses SecureFlight::setVendorPrefs()
     * @uses SecureFlight::setSegmentNumber()
     * @param string $knownTravelerNumber
     * @param \Sabre\PassengerDetailsRQ\Structs\PersonName $personName
     * @param string $redressNumber
     * @param \Sabre\PassengerDetailsRQ\Structs\VendorPrefs $vendorPrefs
     * @param string $segmentNumber
     */
    public function __construct($knownTravelerNumber = null, \Sabre\PassengerDetailsRQ\Structs\PersonName $personName = null, $redressNumber = null, \Sabre\PassengerDetailsRQ\Structs\VendorPrefs $vendorPrefs = null, $segmentNumber = null)
    {
        $this
            ->setKnownTravelerNumber($knownTravelerNumber)
            ->setPersonName($personName)
            ->setRedressNumber($redressNumber)
            ->setVendorPrefs($vendorPrefs)
            ->setSegmentNumber($segmentNumber);
    }
    /**
     * Get KnownTravelerNumber value
     * @return string|null
     */
    public function getKnownTravelerNumber()
    {
        return $this->KnownTravelerNumber;
    }
    /**
     * Set KnownTravelerNumber value
     * @param string $knownTravelerNumber
     * @return \Sabre\PassengerDetailsRQ\Structs\SecureFlight
     */
    public function setKnownTravelerNumber($knownTravelerNumber = null)
    {
        $this->KnownTravelerNumber = $knownTravelerNumber;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \Sabre\PassengerDetailsRQ\Structs\PersonName|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \Sabre\PassengerDetailsRQ\Structs\PersonName $personName
     * @return \Sabre\PassengerDetailsRQ\Structs\SecureFlight
     */
    public function setPersonName(\Sabre\PassengerDetailsRQ\Structs\PersonName $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get RedressNumber value
     * @return string|null
     */
    public function getRedressNumber()
    {
        return $this->RedressNumber;
    }
    /**
     * Set RedressNumber value
     * @param string $redressNumber
     * @return \Sabre\PassengerDetailsRQ\Structs\SecureFlight
     */
    public function setRedressNumber($redressNumber = null)
    {
        $this->RedressNumber = $redressNumber;
        return $this;
    }
    /**
     * Get VendorPrefs value
     * @return \Sabre\PassengerDetailsRQ\Structs\VendorPrefs|null
     */
    public function getVendorPrefs()
    {
        return $this->VendorPrefs;
    }
    /**
     * Set VendorPrefs value
     * @param \Sabre\PassengerDetailsRQ\Structs\VendorPrefs $vendorPrefs
     * @return \Sabre\PassengerDetailsRQ\Structs\SecureFlight
     */
    public function setVendorPrefs(\Sabre\PassengerDetailsRQ\Structs\VendorPrefs $vendorPrefs = null)
    {
        $this->VendorPrefs = $vendorPrefs;
        return $this;
    }
    /**
     * Get SegmentNumber value
     * @return string|null
     */
    public function getSegmentNumber()
    {
        return $this->SegmentNumber;
    }
    /**
     * Set SegmentNumber value
     * @param string $segmentNumber
     * @return \Sabre\PassengerDetailsRQ\Structs\SecureFlight
     */
    public function setSegmentNumber($segmentNumber = null)
    {
        $this->SegmentNumber = $segmentNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\SecureFlight
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
