<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RentalRate Structs
 * Meta informations extracted from the WSDL
 * - documentation: "RentalRate" is used to return vehicle rate-related information.
 * @subpackage Structs
 */
class RentalRate extends AbstractStructBase
{
    /**
     * The Billing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Billing
     */
    public $Billing;
    /**
     * The Client
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Client
     */
    public $Client;
    /**
     * The Corporate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Corporate
     */
    public $Corporate;
    /**
     * The CustLoyalty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\CustLoyalty
     */
    public $CustLoyalty;
    /**
     * The InvoiceRemarks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\InvoiceRemarks
     */
    public $InvoiceRemarks;
    /**
     * The Remarks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Remarks
     */
    public $Remarks;
    /**
     * The ReserveUnderName
     * Meta informations extracted from the WSDL
     * - documentation: "ReserveUnderName" is used to return the name of the customer associated with the vehicle reservation.
     * - minOccurs: 0
     * @var string
     */
    public $ReserveUnderName;
    /**
     * The ServiceInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\ServiceInformation
     */
    public $ServiceInformation;
    /**
     * The TourCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\TourCode
     */
    public $TourCode;
    /**
     * The VehicleTypes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\VehicleTypes
     */
    public $VehicleTypes;
    /**
     * The Voucher
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Voucher
     */
    public $Voucher;
    /**
     * The Changed
     * Meta informations extracted from the WSDL
     * - documentation: ‘@’ preceding rate item or any other car segment field indicating update by car supplier - /RG-¤USD52.72 UNL DY XH8.79 UNL
     * - use: optional
     * @var string
     */
    public $Changed;
    /**
     * The GuaranteedQuoted
     * Meta informations extracted from the WSDL
     * - documentation: Indication of Guaranteed or Subject to Change Rate – ‘/RG-’ and ‘/RQ-’
     * - use: optional
     * @var string
     */
    public $GuaranteedQuoted;
    /**
     * The RateCode
     * Meta informations extracted from the WSDL
     * - documentation: Rate item Rate Code – ‘/RC-¤STDR’
     * - use: optional
     * @var string
     */
    public $RateCode;
    /**
     * The STM_RatePlan
     * Meta informations extracted from the WSDL
     * - documentation: Rate item rate plan – ‘/RG-¤USD52.72 UNL DY XH8.79 UNL’
     * - use: optional
     * @var string
     */
    public $STM_RatePlan;
    /**
     * Constructor method for RentalRate
     * @uses RentalRate::setBilling()
     * @uses RentalRate::setClient()
     * @uses RentalRate::setCorporate()
     * @uses RentalRate::setCustLoyalty()
     * @uses RentalRate::setInvoiceRemarks()
     * @uses RentalRate::setRemarks()
     * @uses RentalRate::setReserveUnderName()
     * @uses RentalRate::setServiceInformation()
     * @uses RentalRate::setTourCode()
     * @uses RentalRate::setVehicleTypes()
     * @uses RentalRate::setVoucher()
     * @uses RentalRate::setChanged()
     * @uses RentalRate::setGuaranteedQuoted()
     * @uses RentalRate::setRateCode()
     * @uses RentalRate::setSTM_RatePlan()
     * @param \Sabre\PassengerDetailsRQ\Structs\Billing $billing
     * @param \Sabre\PassengerDetailsRQ\Structs\Client $client
     * @param \Sabre\PassengerDetailsRQ\Structs\Corporate $corporate
     * @param \Sabre\PassengerDetailsRQ\Structs\CustLoyalty $custLoyalty
     * @param \Sabre\PassengerDetailsRQ\Structs\InvoiceRemarks $invoiceRemarks
     * @param \Sabre\PassengerDetailsRQ\Structs\Remarks $remarks
     * @param string $reserveUnderName
     * @param \Sabre\PassengerDetailsRQ\Structs\ServiceInformation $serviceInformation
     * @param \Sabre\PassengerDetailsRQ\Structs\TourCode $tourCode
     * @param \Sabre\PassengerDetailsRQ\Structs\VehicleTypes $vehicleTypes
     * @param \Sabre\PassengerDetailsRQ\Structs\Voucher $voucher
     * @param string $changed
     * @param string $guaranteedQuoted
     * @param string $rateCode
     * @param string $sTM_RatePlan
     */
    public function __construct(\Sabre\PassengerDetailsRQ\Structs\Billing $billing = null, \Sabre\PassengerDetailsRQ\Structs\Client $client = null, \Sabre\PassengerDetailsRQ\Structs\Corporate $corporate = null, \Sabre\PassengerDetailsRQ\Structs\CustLoyalty $custLoyalty = null, \Sabre\PassengerDetailsRQ\Structs\InvoiceRemarks $invoiceRemarks = null, \Sabre\PassengerDetailsRQ\Structs\Remarks $remarks = null, $reserveUnderName = null, \Sabre\PassengerDetailsRQ\Structs\ServiceInformation $serviceInformation = null, \Sabre\PassengerDetailsRQ\Structs\TourCode $tourCode = null, \Sabre\PassengerDetailsRQ\Structs\VehicleTypes $vehicleTypes = null, \Sabre\PassengerDetailsRQ\Structs\Voucher $voucher = null, $changed = null, $guaranteedQuoted = null, $rateCode = null, $sTM_RatePlan = null)
    {
        $this
            ->setBilling($billing)
            ->setClient($client)
            ->setCorporate($corporate)
            ->setCustLoyalty($custLoyalty)
            ->setInvoiceRemarks($invoiceRemarks)
            ->setRemarks($remarks)
            ->setReserveUnderName($reserveUnderName)
            ->setServiceInformation($serviceInformation)
            ->setTourCode($tourCode)
            ->setVehicleTypes($vehicleTypes)
            ->setVoucher($voucher)
            ->setChanged($changed)
            ->setGuaranteedQuoted($guaranteedQuoted)
            ->setRateCode($rateCode)
            ->setSTM_RatePlan($sTM_RatePlan);
    }
    /**
     * Get Billing value
     * @return \Sabre\PassengerDetailsRQ\Structs\Billing|null
     */
    public function getBilling()
    {
        return $this->Billing;
    }
    /**
     * Set Billing value
     * @param \Sabre\PassengerDetailsRQ\Structs\Billing $billing
     * @return \Sabre\PassengerDetailsRQ\Structs\RentalRate
     */
    public function setBilling(\Sabre\PassengerDetailsRQ\Structs\Billing $billing = null)
    {
        $this->Billing = $billing;
        return $this;
    }
    /**
     * Get Client value
     * @return \Sabre\PassengerDetailsRQ\Structs\Client|null
     */
    public function getClient()
    {
        return $this->Client;
    }
    /**
     * Set Client value
     * @param \Sabre\PassengerDetailsRQ\Structs\Client $client
     * @return \Sabre\PassengerDetailsRQ\Structs\RentalRate
     */
    public function setClient(\Sabre\PassengerDetailsRQ\Structs\Client $client = null)
    {
        $this->Client = $client;
        return $this;
    }
    /**
     * Get Corporate value
     * @return \Sabre\PassengerDetailsRQ\Structs\Corporate|null
     */
    public function getCorporate()
    {
        return $this->Corporate;
    }
    /**
     * Set Corporate value
     * @param \Sabre\PassengerDetailsRQ\Structs\Corporate $corporate
     * @return \Sabre\PassengerDetailsRQ\Structs\RentalRate
     */
    public function setCorporate(\Sabre\PassengerDetailsRQ\Structs\Corporate $corporate = null)
    {
        $this->Corporate = $corporate;
        return $this;
    }
    /**
     * Get CustLoyalty value
     * @return \Sabre\PassengerDetailsRQ\Structs\CustLoyalty|null
     */
    public function getCustLoyalty()
    {
        return $this->CustLoyalty;
    }
    /**
     * Set CustLoyalty value
     * @param \Sabre\PassengerDetailsRQ\Structs\CustLoyalty $custLoyalty
     * @return \Sabre\PassengerDetailsRQ\Structs\RentalRate
     */
    public function setCustLoyalty(\Sabre\PassengerDetailsRQ\Structs\CustLoyalty $custLoyalty = null)
    {
        $this->CustLoyalty = $custLoyalty;
        return $this;
    }
    /**
     * Get InvoiceRemarks value
     * @return \Sabre\PassengerDetailsRQ\Structs\InvoiceRemarks|null
     */
    public function getInvoiceRemarks()
    {
        return $this->InvoiceRemarks;
    }
    /**
     * Set InvoiceRemarks value
     * @param \Sabre\PassengerDetailsRQ\Structs\InvoiceRemarks $invoiceRemarks
     * @return \Sabre\PassengerDetailsRQ\Structs\RentalRate
     */
    public function setInvoiceRemarks(\Sabre\PassengerDetailsRQ\Structs\InvoiceRemarks $invoiceRemarks = null)
    {
        $this->InvoiceRemarks = $invoiceRemarks;
        return $this;
    }
    /**
     * Get Remarks value
     * @return \Sabre\PassengerDetailsRQ\Structs\Remarks|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param \Sabre\PassengerDetailsRQ\Structs\Remarks $remarks
     * @return \Sabre\PassengerDetailsRQ\Structs\RentalRate
     */
    public function setRemarks(\Sabre\PassengerDetailsRQ\Structs\Remarks $remarks = null)
    {
        $this->Remarks = $remarks;
        return $this;
    }
    /**
     * Get ReserveUnderName value
     * @return string|null
     */
    public function getReserveUnderName()
    {
        return $this->ReserveUnderName;
    }
    /**
     * Set ReserveUnderName value
     * @param string $reserveUnderName
     * @return \Sabre\PassengerDetailsRQ\Structs\RentalRate
     */
    public function setReserveUnderName($reserveUnderName = null)
    {
        $this->ReserveUnderName = $reserveUnderName;
        return $this;
    }
    /**
     * Get ServiceInformation value
     * @return \Sabre\PassengerDetailsRQ\Structs\ServiceInformation|null
     */
    public function getServiceInformation()
    {
        return $this->ServiceInformation;
    }
    /**
     * Set ServiceInformation value
     * @param \Sabre\PassengerDetailsRQ\Structs\ServiceInformation $serviceInformation
     * @return \Sabre\PassengerDetailsRQ\Structs\RentalRate
     */
    public function setServiceInformation(\Sabre\PassengerDetailsRQ\Structs\ServiceInformation $serviceInformation = null)
    {
        $this->ServiceInformation = $serviceInformation;
        return $this;
    }
    /**
     * Get TourCode value
     * @return \Sabre\PassengerDetailsRQ\Structs\TourCode|null
     */
    public function getTourCode()
    {
        return $this->TourCode;
    }
    /**
     * Set TourCode value
     * @param \Sabre\PassengerDetailsRQ\Structs\TourCode $tourCode
     * @return \Sabre\PassengerDetailsRQ\Structs\RentalRate
     */
    public function setTourCode(\Sabre\PassengerDetailsRQ\Structs\TourCode $tourCode = null)
    {
        $this->TourCode = $tourCode;
        return $this;
    }
    /**
     * Get VehicleTypes value
     * @return \Sabre\PassengerDetailsRQ\Structs\VehicleTypes|null
     */
    public function getVehicleTypes()
    {
        return $this->VehicleTypes;
    }
    /**
     * Set VehicleTypes value
     * @param \Sabre\PassengerDetailsRQ\Structs\VehicleTypes $vehicleTypes
     * @return \Sabre\PassengerDetailsRQ\Structs\RentalRate
     */
    public function setVehicleTypes(\Sabre\PassengerDetailsRQ\Structs\VehicleTypes $vehicleTypes = null)
    {
        $this->VehicleTypes = $vehicleTypes;
        return $this;
    }
    /**
     * Get Voucher value
     * @return \Sabre\PassengerDetailsRQ\Structs\Voucher|null
     */
    public function getVoucher()
    {
        return $this->Voucher;
    }
    /**
     * Set Voucher value
     * @param \Sabre\PassengerDetailsRQ\Structs\Voucher $voucher
     * @return \Sabre\PassengerDetailsRQ\Structs\RentalRate
     */
    public function setVoucher(\Sabre\PassengerDetailsRQ\Structs\Voucher $voucher = null)
    {
        $this->Voucher = $voucher;
        return $this;
    }
    /**
     * Get Changed value
     * @return string|null
     */
    public function getChanged()
    {
        return $this->Changed;
    }
    /**
     * Set Changed value
     * @param string $changed
     * @return \Sabre\PassengerDetailsRQ\Structs\RentalRate
     */
    public function setChanged($changed = null)
    {
        $this->Changed = $changed;
        return $this;
    }
    /**
     * Get GuaranteedQuoted value
     * @return string|null
     */
    public function getGuaranteedQuoted()
    {
        return $this->GuaranteedQuoted;
    }
    /**
     * Set GuaranteedQuoted value
     * @param string $guaranteedQuoted
     * @return \Sabre\PassengerDetailsRQ\Structs\RentalRate
     */
    public function setGuaranteedQuoted($guaranteedQuoted = null)
    {
        $this->GuaranteedQuoted = $guaranteedQuoted;
        return $this;
    }
    /**
     * Get RateCode value
     * @return string|null
     */
    public function getRateCode()
    {
        return $this->RateCode;
    }
    /**
     * Set RateCode value
     * @param string $rateCode
     * @return \Sabre\PassengerDetailsRQ\Structs\RentalRate
     */
    public function setRateCode($rateCode = null)
    {
        $this->RateCode = $rateCode;
        return $this;
    }
    /**
     * Get STM_RatePlan value
     * @return string|null
     */
    public function getSTM_RatePlan()
    {
        return $this->STM_RatePlan;
    }
    /**
     * Set STM_RatePlan value
     * @param string $sTM_RatePlan
     * @return \Sabre\PassengerDetailsRQ\Structs\RentalRate
     */
    public function setSTM_RatePlan($sTM_RatePlan = null)
    {
        $this->STM_RatePlan = $sTM_RatePlan;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\RentalRate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
