<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueueInfo Structs
 * Meta informations extracted from the WSDL
 * - documentation: Holds Queue placement details
 * @subpackage Structs
 */
class QueueInfo extends AbstractStructBase
{
    /**
     * The QueueIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 3
     * @var \Sabre\PassengerDetailsRQ\Structs\QueueIdentifier[]
     */
    public $QueueIdentifier;
    /**
     * The UniqueID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 6
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\UniqueID[]
     */
    public $UniqueID;
    /**
     * The Placement
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Placement[]
     */
    public $Placement;
    /**
     * Constructor method for QueueInfo
     * @uses QueueInfo::setQueueIdentifier()
     * @uses QueueInfo::setUniqueID()
     * @uses QueueInfo::setPlacement()
     * @param \Sabre\PassengerDetailsRQ\Structs\QueueIdentifier[] $queueIdentifier
     * @param \Sabre\PassengerDetailsRQ\Structs\UniqueID[] $uniqueID
     * @param \Sabre\PassengerDetailsRQ\Structs\Placement[] $placement
     */
    public function __construct(array $queueIdentifier = array(), array $uniqueID = array(), array $placement = array())
    {
        $this
            ->setQueueIdentifier($queueIdentifier)
            ->setUniqueID($uniqueID)
            ->setPlacement($placement);
    }
    /**
     * Get QueueIdentifier value
     * @return \Sabre\PassengerDetailsRQ\Structs\QueueIdentifier[]|null
     */
    public function getQueueIdentifier()
    {
        return $this->QueueIdentifier;
    }
    /**
     * Set QueueIdentifier value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\QueueIdentifier[] $queueIdentifier
     * @return \Sabre\PassengerDetailsRQ\Structs\QueueInfo
     */
    public function setQueueIdentifier(array $queueIdentifier = array())
    {
        $this->QueueIdentifier = $queueIdentifier;
        return $this;
    }
    /**
     * Add item to QueueIdentifier value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\QueueIdentifier $item
     * @return \Sabre\PassengerDetailsRQ\Structs\QueueInfo
     */
    public function addToQueueIdentifier(\Sabre\PassengerDetailsRQ\Structs\QueueIdentifier $item)
    {
        $this->QueueIdentifier[] = $item;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return \Sabre\PassengerDetailsRQ\Structs\UniqueID[]|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\UniqueID[] $uniqueID
     * @return \Sabre\PassengerDetailsRQ\Structs\QueueInfo
     */
    public function setUniqueID(array $uniqueID = array())
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Add item to UniqueID value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\UniqueID $item
     * @return \Sabre\PassengerDetailsRQ\Structs\QueueInfo
     */
    public function addToUniqueID(\Sabre\PassengerDetailsRQ\Structs\UniqueID $item)
    {
        $this->UniqueID[] = $item;
        return $this;
    }
    /**
     * Get Placement value
     * @return \Sabre\PassengerDetailsRQ\Structs\Placement[]|null
     */
    public function getPlacement()
    {
        return $this->Placement;
    }
    /**
     * Set Placement value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\Placement[] $placement
     * @return \Sabre\PassengerDetailsRQ\Structs\QueueInfo
     */
    public function setPlacement(array $placement = array())
    {
        $this->Placement = $placement;
        return $this;
    }
    /**
     * Add item to Placement value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\Placement $item
     * @return \Sabre\PassengerDetailsRQ\Structs\QueueInfo
     */
    public function addToPlacement(\Sabre\PassengerDetailsRQ\Structs\Placement $item)
    {
        $this->Placement[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\QueueInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
