<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PTC_FareBreakdown Structs
 * @subpackage Structs
 */
class PTC_FareBreakdown extends AbstractStructBase
{
    /**
     * The NetRemits
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\NetRemits
     */
    public $NetRemits;
    /**
     * The Endorsements
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Endorsements
     */
    public $Endorsements;
    /**
     * The FareBasis
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\FareBasis[]
     */
    public $FareBasis;
    /**
     * The FareCalculation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\FareCalculation
     */
    public $FareCalculation;
    /**
     * The FareSource
     * Meta informations extracted from the WSDL
     * - documentation: "FareSource" is used to return the fare source.
     * - minOccurs: 0
     * @var string
     */
    public $FareSource;
    /**
     * The FlightSegment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\FlightSegment[]
     */
    public $FlightSegment;
    /**
     * The ResTicketingRestrictions
     * Meta informations extracted from the WSDL
     * - documentation: "ResTicketingRestrictions" is used to return last day to purchase-related information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ResTicketingRestrictions;
    /**
     * The TourCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\TourCode
     */
    public $TourCode;
    /**
     * Constructor method for PTC_FareBreakdown
     * @uses PTC_FareBreakdown::setNetRemits()
     * @uses PTC_FareBreakdown::setEndorsements()
     * @uses PTC_FareBreakdown::setFareBasis()
     * @uses PTC_FareBreakdown::setFareCalculation()
     * @uses PTC_FareBreakdown::setFareSource()
     * @uses PTC_FareBreakdown::setFlightSegment()
     * @uses PTC_FareBreakdown::setResTicketingRestrictions()
     * @uses PTC_FareBreakdown::setTourCode()
     * @param \Sabre\PassengerDetailsRQ\Structs\NetRemits $netRemits
     * @param \Sabre\PassengerDetailsRQ\Structs\Endorsements $endorsements
     * @param \Sabre\PassengerDetailsRQ\Structs\FareBasis[] $fareBasis
     * @param \Sabre\PassengerDetailsRQ\Structs\FareCalculation $fareCalculation
     * @param string $fareSource
     * @param \Sabre\PassengerDetailsRQ\Structs\FlightSegment[] $flightSegment
     * @param string[] $resTicketingRestrictions
     * @param \Sabre\PassengerDetailsRQ\Structs\TourCode $tourCode
     */
    public function __construct(\Sabre\PassengerDetailsRQ\Structs\NetRemits $netRemits = null, \Sabre\PassengerDetailsRQ\Structs\Endorsements $endorsements = null, array $fareBasis = array(), \Sabre\PassengerDetailsRQ\Structs\FareCalculation $fareCalculation = null, $fareSource = null, array $flightSegment = array(), array $resTicketingRestrictions = array(), \Sabre\PassengerDetailsRQ\Structs\TourCode $tourCode = null)
    {
        $this
            ->setNetRemits($netRemits)
            ->setEndorsements($endorsements)
            ->setFareBasis($fareBasis)
            ->setFareCalculation($fareCalculation)
            ->setFareSource($fareSource)
            ->setFlightSegment($flightSegment)
            ->setResTicketingRestrictions($resTicketingRestrictions)
            ->setTourCode($tourCode);
    }
    /**
     * Get NetRemits value
     * @return \Sabre\PassengerDetailsRQ\Structs\NetRemits|null
     */
    public function getNetRemits()
    {
        return $this->NetRemits;
    }
    /**
     * Set NetRemits value
     * @param \Sabre\PassengerDetailsRQ\Structs\NetRemits $netRemits
     * @return \Sabre\PassengerDetailsRQ\Structs\PTC_FareBreakdown
     */
    public function setNetRemits(\Sabre\PassengerDetailsRQ\Structs\NetRemits $netRemits = null)
    {
        $this->NetRemits = $netRemits;
        return $this;
    }
    /**
     * Get Endorsements value
     * @return \Sabre\PassengerDetailsRQ\Structs\Endorsements|null
     */
    public function getEndorsements()
    {
        return $this->Endorsements;
    }
    /**
     * Set Endorsements value
     * @param \Sabre\PassengerDetailsRQ\Structs\Endorsements $endorsements
     * @return \Sabre\PassengerDetailsRQ\Structs\PTC_FareBreakdown
     */
    public function setEndorsements(\Sabre\PassengerDetailsRQ\Structs\Endorsements $endorsements = null)
    {
        $this->Endorsements = $endorsements;
        return $this;
    }
    /**
     * Get FareBasis value
     * @return \Sabre\PassengerDetailsRQ\Structs\FareBasis[]|null
     */
    public function getFareBasis()
    {
        return $this->FareBasis;
    }
    /**
     * Set FareBasis value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\FareBasis[] $fareBasis
     * @return \Sabre\PassengerDetailsRQ\Structs\PTC_FareBreakdown
     */
    public function setFareBasis(array $fareBasis = array())
    {
        $this->FareBasis = $fareBasis;
        return $this;
    }
    /**
     * Add item to FareBasis value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\FareBasis $item
     * @return \Sabre\PassengerDetailsRQ\Structs\PTC_FareBreakdown
     */
    public function addToFareBasis(\Sabre\PassengerDetailsRQ\Structs\FareBasis $item)
    {
        $this->FareBasis[] = $item;
        return $this;
    }
    /**
     * Get FareCalculation value
     * @return \Sabre\PassengerDetailsRQ\Structs\FareCalculation|null
     */
    public function getFareCalculation()
    {
        return $this->FareCalculation;
    }
    /**
     * Set FareCalculation value
     * @param \Sabre\PassengerDetailsRQ\Structs\FareCalculation $fareCalculation
     * @return \Sabre\PassengerDetailsRQ\Structs\PTC_FareBreakdown
     */
    public function setFareCalculation(\Sabre\PassengerDetailsRQ\Structs\FareCalculation $fareCalculation = null)
    {
        $this->FareCalculation = $fareCalculation;
        return $this;
    }
    /**
     * Get FareSource value
     * @return string|null
     */
    public function getFareSource()
    {
        return $this->FareSource;
    }
    /**
     * Set FareSource value
     * @param string $fareSource
     * @return \Sabre\PassengerDetailsRQ\Structs\PTC_FareBreakdown
     */
    public function setFareSource($fareSource = null)
    {
        $this->FareSource = $fareSource;
        return $this;
    }
    /**
     * Get FlightSegment value
     * @return \Sabre\PassengerDetailsRQ\Structs\FlightSegment[]|null
     */
    public function getFlightSegment()
    {
        return $this->FlightSegment;
    }
    /**
     * Set FlightSegment value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\FlightSegment[] $flightSegment
     * @return \Sabre\PassengerDetailsRQ\Structs\PTC_FareBreakdown
     */
    public function setFlightSegment(array $flightSegment = array())
    {
        $this->FlightSegment = $flightSegment;
        return $this;
    }
    /**
     * Add item to FlightSegment value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\FlightSegment $item
     * @return \Sabre\PassengerDetailsRQ\Structs\PTC_FareBreakdown
     */
    public function addToFlightSegment(\Sabre\PassengerDetailsRQ\Structs\FlightSegment $item)
    {
        $this->FlightSegment[] = $item;
        return $this;
    }
    /**
     * Get ResTicketingRestrictions value
     * @return string[]|null
     */
    public function getResTicketingRestrictions()
    {
        return $this->ResTicketingRestrictions;
    }
    /**
     * Set ResTicketingRestrictions value
     * @throws \InvalidArgumentException
     * @param string[] $resTicketingRestrictions
     * @return \Sabre\PassengerDetailsRQ\Structs\PTC_FareBreakdown
     */
    public function setResTicketingRestrictions(array $resTicketingRestrictions = array())
    {
        $this->ResTicketingRestrictions = $resTicketingRestrictions;
        return $this;
    }
    /**
     * Add item to ResTicketingRestrictions value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\PassengerDetailsRQ\Structs\PTC_FareBreakdown
     */
    public function addToResTicketingRestrictions($item)
    {
        $this->ResTicketingRestrictions[] = $item;
        return $this;
    }
    /**
     * Get TourCode value
     * @return \Sabre\PassengerDetailsRQ\Structs\TourCode|null
     */
    public function getTourCode()
    {
        return $this->TourCode;
    }
    /**
     * Set TourCode value
     * @param \Sabre\PassengerDetailsRQ\Structs\TourCode $tourCode
     * @return \Sabre\PassengerDetailsRQ\Structs\PTC_FareBreakdown
     */
    public function setTourCode(\Sabre\PassengerDetailsRQ\Structs\TourCode $tourCode = null)
    {
        $this->TourCode = $tourCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\PTC_FareBreakdown
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
