<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginLocation Structs
 * @subpackage Structs
 */
class OriginLocation extends AbstractStructBase
{
    /**
     * The LocationCode
     * Meta informations extracted from the WSDL
     * - documentation: "LocationCode" is used to return the airport code associated with the particular flight segment. | "LocationCode" is used to return the origin location code associated with the particular segment. | "LocationCode" is used to return
     * the location code associated with the particular cruise segment. | "LocationCode" is used to return the departure airport code. | "LocationCode" is used to return the departure location code associated with the particular insurance segment. |
     * "LocationCode" is used to return the location code associated with the particular segment. | "LocationCode" is used to return the departure location code associated with the particular rail segment. | "LocationCode" is used to return the departure
     * airport code. | "LocationCode" is used to return the service city location code associated with the particular segment. | "LocationCode" is used to return the service city location code associated with the particular segment.
     * - use: optional
     * @var string
     */
    public $LocationCode;
    /**
     * The DepartureDate
     * Meta informations extracted from the WSDL
     * - documentation: "DepartureDate" is used to return the departure dates associated with the particular cruise segment. DepartureDate" follows this format: MM:DD | "DepartureDate" is used to return departure date information associated with the
     * particular rail segment. "DepartureDate" follows this format: MM-DD | A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - minOccurs: 0
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $DepartureDate;
    /**
     * The DepartureTime
     * Meta informations extracted from the WSDL
     * - documentation: "DepartureTime" is used to return the departure time associated with the particular cruise segment. "DepartureTime" follows this format: HH:MM | "DepartureTime" is used to return departure time information associated with the
     * particular rail segment. "DepartureTime" follows this format: HH:MM | A simple time type. Seconds can be omitted, since those values are not propagated to the Sabre backend systems. Accepted formats: "hh:mm:ss" or "hh:mm"
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - pattern: ([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string[]
     */
    public $DepartureTime;
    /**
     * The Point
     * Meta informations extracted from the WSDL
     * - documentation: "Point" is used to return the departure location point associated with the particular cruise segment. | "Point" is used to return the departure location point associated with the particular rail segment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Point;
    /**
     * The LocationName
     * Meta informations extracted from the WSDL
     * - documentation: "LocationName" is used to return the arrival location name associated with the particular cruise segment. | "LocationName" is used to return the location name associated with the particular segment. | "LocationName" is used to return
     * the departure location name associated with the particular rail segment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - use: optional
     * @var string[]
     */
    public $LocationName;
    /**
     * The Terminal
     * Meta informations extracted from the WSDL
     * - documentation: "Terminal" is used to return the departure airport terminal.
     * - use: optional
     * @var string
     */
    public $Terminal;
    /**
     * The TerminalCode
     * Meta informations extracted from the WSDL
     * - documentation: "TerminalCode" is used to return the departure airport terminal code.
     * - use: optional
     * @var string
     */
    public $TerminalCode;
    /**
     * Constructor method for OriginLocation
     * @uses OriginLocation::setLocationCode()
     * @uses OriginLocation::setDepartureDate()
     * @uses OriginLocation::setDepartureTime()
     * @uses OriginLocation::setPoint()
     * @uses OriginLocation::setLocationName()
     * @uses OriginLocation::setTerminal()
     * @uses OriginLocation::setTerminalCode()
     * @param string $locationCode
     * @param string $departureDate
     * @param string[] $departureTime
     * @param string[] $point
     * @param string[] $locationName
     * @param string $terminal
     * @param string $terminalCode
     */
    public function __construct($locationCode = null, $departureDate = null, array $departureTime = array(), array $point = array(), array $locationName = array(), $terminal = null, $terminalCode = null)
    {
        $this
            ->setLocationCode($locationCode)
            ->setDepartureDate($departureDate)
            ->setDepartureTime($departureTime)
            ->setPoint($point)
            ->setLocationName($locationName)
            ->setTerminal($terminal)
            ->setTerminalCode($terminalCode);
    }
    /**
     * Get LocationCode value
     * @return string|null
     */
    public function getLocationCode()
    {
        return $this->LocationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \Sabre\PassengerDetailsRQ\Structs\OriginLocation
     */
    public function setLocationCode($locationCode = null)
    {
        $this->LocationCode = $locationCode;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \Sabre\PassengerDetailsRQ\Structs\OriginLocation
     */
    public function setDepartureDate($departureDate = null)
    {
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get DepartureTime value
     * @return string[]|null
     */
    public function getDepartureTime()
    {
        return $this->DepartureTime;
    }
    /**
     * Set DepartureTime value
     * @throws \InvalidArgumentException
     * @param string[] $departureTime
     * @return \Sabre\PassengerDetailsRQ\Structs\OriginLocation
     */
    public function setDepartureTime(array $departureTime = array())
    {
        $this->DepartureTime = $departureTime;
        return $this;
    }
    /**
     * Add item to DepartureTime value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\PassengerDetailsRQ\Structs\OriginLocation
     */
    public function addToDepartureTime($item)
    {
        $this->DepartureTime[] = $item;
        return $this;
    }
    /**
     * Get Point value
     * @return string[]|null
     */
    public function getPoint()
    {
        return $this->Point;
    }
    /**
     * Set Point value
     * @throws \InvalidArgumentException
     * @param string[] $point
     * @return \Sabre\PassengerDetailsRQ\Structs\OriginLocation
     */
    public function setPoint(array $point = array())
    {
        $this->Point = $point;
        return $this;
    }
    /**
     * Add item to Point value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\PassengerDetailsRQ\Structs\OriginLocation
     */
    public function addToPoint($item)
    {
        $this->Point[] = $item;
        return $this;
    }
    /**
     * Get LocationName value
     * @return string[]|null
     */
    public function getLocationName()
    {
        return $this->LocationName;
    }
    /**
     * Set LocationName value
     * @throws \InvalidArgumentException
     * @param string[] $locationName
     * @return \Sabre\PassengerDetailsRQ\Structs\OriginLocation
     */
    public function setLocationName(array $locationName = array())
    {
        $this->LocationName = $locationName;
        return $this;
    }
    /**
     * Add item to LocationName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\PassengerDetailsRQ\Structs\OriginLocation
     */
    public function addToLocationName($item)
    {
        $this->LocationName[] = $item;
        return $this;
    }
    /**
     * Get Terminal value
     * @return string|null
     */
    public function getTerminal()
    {
        return $this->Terminal;
    }
    /**
     * Set Terminal value
     * @param string $terminal
     * @return \Sabre\PassengerDetailsRQ\Structs\OriginLocation
     */
    public function setTerminal($terminal = null)
    {
        $this->Terminal = $terminal;
        return $this;
    }
    /**
     * Get TerminalCode value
     * @return string|null
     */
    public function getTerminalCode()
    {
        return $this->TerminalCode;
    }
    /**
     * Set TerminalCode value
     * @param string $terminalCode
     * @return \Sabre\PassengerDetailsRQ\Structs\OriginLocation
     */
    public function setTerminalCode($terminalCode = null)
    {
        $this->TerminalCode = $terminalCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\OriginLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
