<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OACType Structs
 * @subpackage Structs
 */
class OACType extends AbstractStructBase
{
    /**
     * The PartitionId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PartitionId;
    /**
     * The AccountingCityCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AccountingCityCode;
    /**
     * The AccountingCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AccountingCode;
    /**
     * The AccountingOfficeStationCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AccountingOfficeStationCode;
    /**
     * Constructor method for OACType
     * @uses OACType::setPartitionId()
     * @uses OACType::setAccountingCityCode()
     * @uses OACType::setAccountingCode()
     * @uses OACType::setAccountingOfficeStationCode()
     * @param string $partitionId
     * @param string $accountingCityCode
     * @param string $accountingCode
     * @param string $accountingOfficeStationCode
     */
    public function __construct($partitionId = null, $accountingCityCode = null, $accountingCode = null, $accountingOfficeStationCode = null)
    {
        $this
            ->setPartitionId($partitionId)
            ->setAccountingCityCode($accountingCityCode)
            ->setAccountingCode($accountingCode)
            ->setAccountingOfficeStationCode($accountingOfficeStationCode);
    }
    /**
     * Get PartitionId value
     * @return string|null
     */
    public function getPartitionId()
    {
        return $this->PartitionId;
    }
    /**
     * Set PartitionId value
     * @param string $partitionId
     * @return \Sabre\PassengerDetailsRQ\Structs\OACType
     */
    public function setPartitionId($partitionId = null)
    {
        $this->PartitionId = $partitionId;
        return $this;
    }
    /**
     * Get AccountingCityCode value
     * @return string|null
     */
    public function getAccountingCityCode()
    {
        return $this->AccountingCityCode;
    }
    /**
     * Set AccountingCityCode value
     * @param string $accountingCityCode
     * @return \Sabre\PassengerDetailsRQ\Structs\OACType
     */
    public function setAccountingCityCode($accountingCityCode = null)
    {
        $this->AccountingCityCode = $accountingCityCode;
        return $this;
    }
    /**
     * Get AccountingCode value
     * @return string|null
     */
    public function getAccountingCode()
    {
        return $this->AccountingCode;
    }
    /**
     * Set AccountingCode value
     * @param string $accountingCode
     * @return \Sabre\PassengerDetailsRQ\Structs\OACType
     */
    public function setAccountingCode($accountingCode = null)
    {
        $this->AccountingCode = $accountingCode;
        return $this;
    }
    /**
     * Get AccountingOfficeStationCode value
     * @return string|null
     */
    public function getAccountingOfficeStationCode()
    {
        return $this->AccountingOfficeStationCode;
    }
    /**
     * Set AccountingOfficeStationCode value
     * @param string $accountingOfficeStationCode
     * @return \Sabre\PassengerDetailsRQ\Structs\OACType
     */
    public function setAccountingOfficeStationCode($accountingOfficeStationCode = null)
    {
        $this->AccountingOfficeStationCode = $accountingOfficeStationCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\OACType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
