<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NetTicketingInfo Structs
 * Meta informations extracted from the WSDL
 * - documentation: "NetTicketingInfo" holds the NetTicketing Information
 * @subpackage Structs
 */
class NetTicketingInfo extends AbstractStructBase
{
    /**
     * The NetFareDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\NetFareDetails
     */
    public $NetFareDetails;
    /**
     * The SellingFareDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\SellingFareDetails
     */
    public $SellingFareDetails;
    /**
     * The AccountCode
     * Meta informations extracted from the WSDL
     * - documentation: "AccountCode" returns the account code
     * - use: optional
     * @var string
     */
    public $AccountCode;
    /**
     * The CorporateId
     * Meta informations extracted from the WSDL
     * - documentation: "CorporateId" returns the Corporate Id
     * - use: optional
     * @var string
     */
    public $CorporateId;
    /**
     * Constructor method for NetTicketingInfo
     * @uses NetTicketingInfo::setNetFareDetails()
     * @uses NetTicketingInfo::setSellingFareDetails()
     * @uses NetTicketingInfo::setAccountCode()
     * @uses NetTicketingInfo::setCorporateId()
     * @param \Sabre\PassengerDetailsRQ\Structs\NetFareDetails $netFareDetails
     * @param \Sabre\PassengerDetailsRQ\Structs\SellingFareDetails $sellingFareDetails
     * @param string $accountCode
     * @param string $corporateId
     */
    public function __construct(\Sabre\PassengerDetailsRQ\Structs\NetFareDetails $netFareDetails = null, \Sabre\PassengerDetailsRQ\Structs\SellingFareDetails $sellingFareDetails = null, $accountCode = null, $corporateId = null)
    {
        $this
            ->setNetFareDetails($netFareDetails)
            ->setSellingFareDetails($sellingFareDetails)
            ->setAccountCode($accountCode)
            ->setCorporateId($corporateId);
    }
    /**
     * Get NetFareDetails value
     * @return \Sabre\PassengerDetailsRQ\Structs\NetFareDetails|null
     */
    public function getNetFareDetails()
    {
        return $this->NetFareDetails;
    }
    /**
     * Set NetFareDetails value
     * @param \Sabre\PassengerDetailsRQ\Structs\NetFareDetails $netFareDetails
     * @return \Sabre\PassengerDetailsRQ\Structs\NetTicketingInfo
     */
    public function setNetFareDetails(\Sabre\PassengerDetailsRQ\Structs\NetFareDetails $netFareDetails = null)
    {
        $this->NetFareDetails = $netFareDetails;
        return $this;
    }
    /**
     * Get SellingFareDetails value
     * @return \Sabre\PassengerDetailsRQ\Structs\SellingFareDetails|null
     */
    public function getSellingFareDetails()
    {
        return $this->SellingFareDetails;
    }
    /**
     * Set SellingFareDetails value
     * @param \Sabre\PassengerDetailsRQ\Structs\SellingFareDetails $sellingFareDetails
     * @return \Sabre\PassengerDetailsRQ\Structs\NetTicketingInfo
     */
    public function setSellingFareDetails(\Sabre\PassengerDetailsRQ\Structs\SellingFareDetails $sellingFareDetails = null)
    {
        $this->SellingFareDetails = $sellingFareDetails;
        return $this;
    }
    /**
     * Get AccountCode value
     * @return string|null
     */
    public function getAccountCode()
    {
        return $this->AccountCode;
    }
    /**
     * Set AccountCode value
     * @param string $accountCode
     * @return \Sabre\PassengerDetailsRQ\Structs\NetTicketingInfo
     */
    public function setAccountCode($accountCode = null)
    {
        $this->AccountCode = $accountCode;
        return $this;
    }
    /**
     * Get CorporateId value
     * @return string|null
     */
    public function getCorporateId()
    {
        return $this->CorporateId;
    }
    /**
     * Set CorporateId value
     * @param string $corporateId
     * @return \Sabre\PassengerDetailsRQ\Structs\NetTicketingInfo
     */
    public function setCorporateId($corporateId = null)
    {
        $this->CorporateId = $corporateId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\NetTicketingInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
