<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItineraryRef Structs
 * @subpackage Structs
 */
class ItineraryRef extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - documentation: "ID" is used to return the record locator.
     * - use: optional
     * @var string
     */
    public $ID;
    /**
     * The Header
     * Meta informations extracted from the WSDL
     * - documentation: "Header" is used to return miscellaneous record header-related text if applicable.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Header;
    /**
     * The Source
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Source
     */
    public $Source;
    /**
     * The TravelPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\TravelPolicy[]
     */
    public $TravelPolicy;
    /**
     * The AccountingCity
     * Meta informations extracted from the WSDL
     * - documentation: "AccountingCity" is used to return the customer's accounting city.
     * - use: optional
     * @var string
     */
    public $AccountingCity;
    /**
     * The AccountingCode
     * Meta informations extracted from the WSDL
     * - documentation: "AccountingCode" is used to return the customer's accounting code.
     * - use: optional
     * @var string
     */
    public $AccountingCode;
    /**
     * The AirExtras
     * Meta informations extracted from the WSDL
     * - documentation: "AirExtras" is used to indicate whether or not air extra-related information pertains to the particular record.
     * - use: optional
     * @var bool
     */
    public $AirExtras;
    /**
     * The CustomerIdentifier
     * Meta informations extracted from the WSDL
     * - documentation: "CustomerIdentifier" is used to return the customer's DK number.
     * - use: optional
     * @var string
     */
    public $CustomerIdentifier;
    /**
     * The InhibitCode
     * Meta informations extracted from the WSDL
     * - documentation: "InhibitCode" is utilized to return the viewership code associated with the particular record.
     * - use: optional
     * @var string
     */
    public $InhibitCode;
    /**
     * The OfficeStationCode
     * Meta informations extracted from the WSDL
     * - documentation: "OfficeStationCode" is is used to return the customer's office/station code.
     * - use: optional
     * @var string
     */
    public $OfficeStationCode;
    /**
     * The OtherSystemID
     * Meta informations extracted from the WSDL
     * - documentation: "OtherSystemID" is is used to return OA record locator information if applicable.
     * - use: optional
     * @var string
     */
    public $OtherSystemID;
    /**
     * The PartitionID
     * Meta informations extracted from the WSDL
     * - documentation: "PartitionID" is is used to return the host partition associated with the particular record.
     * - use: optional
     * @var string
     */
    public $PartitionID;
    /**
     * The PrimeHostID
     * Meta informations extracted from the WSDL
     * - documentation: "PrimeHostID" is is used to return the prime host ID associated with the particular record.
     * - use: optional
     * @var string
     */
    public $PrimeHostID;
    /**
     * The TicketingCarrier
     * Meta informations extracted from the WSDL
     * - documentation: "TicketingCarrier" is is used to return the ticketing carrier code.
     * - use: optional
     * @var string
     */
    public $TicketingCarrier;
    /**
     * The PhaseIVIndicator
     * Meta informations extracted from the WSDL
     * - documentation: Indicates presence of phase IV record. Possible values: A (active) I (inactive), empty or absent if no Phase IV exists.
     * - use: optional
     * @var string
     */
    public $PhaseIVIndicator;
    /**
     * Constructor method for ItineraryRef
     * @uses ItineraryRef::setID()
     * @uses ItineraryRef::setHeader()
     * @uses ItineraryRef::setSource()
     * @uses ItineraryRef::setTravelPolicy()
     * @uses ItineraryRef::setAccountingCity()
     * @uses ItineraryRef::setAccountingCode()
     * @uses ItineraryRef::setAirExtras()
     * @uses ItineraryRef::setCustomerIdentifier()
     * @uses ItineraryRef::setInhibitCode()
     * @uses ItineraryRef::setOfficeStationCode()
     * @uses ItineraryRef::setOtherSystemID()
     * @uses ItineraryRef::setPartitionID()
     * @uses ItineraryRef::setPrimeHostID()
     * @uses ItineraryRef::setTicketingCarrier()
     * @uses ItineraryRef::setPhaseIVIndicator()
     * @param string $iD
     * @param string[] $header
     * @param \Sabre\PassengerDetailsRQ\Structs\Source $source
     * @param \Sabre\PassengerDetailsRQ\Structs\TravelPolicy[] $travelPolicy
     * @param string $accountingCity
     * @param string $accountingCode
     * @param bool $airExtras
     * @param string $customerIdentifier
     * @param string $inhibitCode
     * @param string $officeStationCode
     * @param string $otherSystemID
     * @param string $partitionID
     * @param string $primeHostID
     * @param string $ticketingCarrier
     * @param string $phaseIVIndicator
     */
    public function __construct($iD = null, array $header = array(), \Sabre\PassengerDetailsRQ\Structs\Source $source = null, array $travelPolicy = array(), $accountingCity = null, $accountingCode = null, $airExtras = null, $customerIdentifier = null, $inhibitCode = null, $officeStationCode = null, $otherSystemID = null, $partitionID = null, $primeHostID = null, $ticketingCarrier = null, $phaseIVIndicator = null)
    {
        $this
            ->setID($iD)
            ->setHeader($header)
            ->setSource($source)
            ->setTravelPolicy($travelPolicy)
            ->setAccountingCity($accountingCity)
            ->setAccountingCode($accountingCode)
            ->setAirExtras($airExtras)
            ->setCustomerIdentifier($customerIdentifier)
            ->setInhibitCode($inhibitCode)
            ->setOfficeStationCode($officeStationCode)
            ->setOtherSystemID($otherSystemID)
            ->setPartitionID($partitionID)
            ->setPrimeHostID($primeHostID)
            ->setTicketingCarrier($ticketingCarrier)
            ->setPhaseIVIndicator($phaseIVIndicator);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryRef
     */
    public function setID($iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Header value
     * @return string[]|null
     */
    public function getHeader()
    {
        return $this->Header;
    }
    /**
     * Set Header value
     * @throws \InvalidArgumentException
     * @param string[] $header
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryRef
     */
    public function setHeader(array $header = array())
    {
        $this->Header = $header;
        return $this;
    }
    /**
     * Add item to Header value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryRef
     */
    public function addToHeader($item)
    {
        $this->Header[] = $item;
        return $this;
    }
    /**
     * Get Source value
     * @return \Sabre\PassengerDetailsRQ\Structs\Source|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param \Sabre\PassengerDetailsRQ\Structs\Source $source
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryRef
     */
    public function setSource(\Sabre\PassengerDetailsRQ\Structs\Source $source = null)
    {
        $this->Source = $source;
        return $this;
    }
    /**
     * Get TravelPolicy value
     * @return \Sabre\PassengerDetailsRQ\Structs\TravelPolicy[]|null
     */
    public function getTravelPolicy()
    {
        return $this->TravelPolicy;
    }
    /**
     * Set TravelPolicy value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\TravelPolicy[] $travelPolicy
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryRef
     */
    public function setTravelPolicy(array $travelPolicy = array())
    {
        $this->TravelPolicy = $travelPolicy;
        return $this;
    }
    /**
     * Add item to TravelPolicy value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\TravelPolicy $item
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryRef
     */
    public function addToTravelPolicy(\Sabre\PassengerDetailsRQ\Structs\TravelPolicy $item)
    {
        $this->TravelPolicy[] = $item;
        return $this;
    }
    /**
     * Get AccountingCity value
     * @return string|null
     */
    public function getAccountingCity()
    {
        return $this->AccountingCity;
    }
    /**
     * Set AccountingCity value
     * @param string $accountingCity
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryRef
     */
    public function setAccountingCity($accountingCity = null)
    {
        $this->AccountingCity = $accountingCity;
        return $this;
    }
    /**
     * Get AccountingCode value
     * @return string|null
     */
    public function getAccountingCode()
    {
        return $this->AccountingCode;
    }
    /**
     * Set AccountingCode value
     * @param string $accountingCode
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryRef
     */
    public function setAccountingCode($accountingCode = null)
    {
        $this->AccountingCode = $accountingCode;
        return $this;
    }
    /**
     * Get AirExtras value
     * @return bool|null
     */
    public function getAirExtras()
    {
        return $this->AirExtras;
    }
    /**
     * Set AirExtras value
     * @param bool $airExtras
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryRef
     */
    public function setAirExtras($airExtras = null)
    {
        $this->AirExtras = $airExtras;
        return $this;
    }
    /**
     * Get CustomerIdentifier value
     * @return string|null
     */
    public function getCustomerIdentifier()
    {
        return $this->CustomerIdentifier;
    }
    /**
     * Set CustomerIdentifier value
     * @param string $customerIdentifier
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryRef
     */
    public function setCustomerIdentifier($customerIdentifier = null)
    {
        $this->CustomerIdentifier = $customerIdentifier;
        return $this;
    }
    /**
     * Get InhibitCode value
     * @return string|null
     */
    public function getInhibitCode()
    {
        return $this->InhibitCode;
    }
    /**
     * Set InhibitCode value
     * @param string $inhibitCode
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryRef
     */
    public function setInhibitCode($inhibitCode = null)
    {
        $this->InhibitCode = $inhibitCode;
        return $this;
    }
    /**
     * Get OfficeStationCode value
     * @return string|null
     */
    public function getOfficeStationCode()
    {
        return $this->OfficeStationCode;
    }
    /**
     * Set OfficeStationCode value
     * @param string $officeStationCode
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryRef
     */
    public function setOfficeStationCode($officeStationCode = null)
    {
        $this->OfficeStationCode = $officeStationCode;
        return $this;
    }
    /**
     * Get OtherSystemID value
     * @return string|null
     */
    public function getOtherSystemID()
    {
        return $this->OtherSystemID;
    }
    /**
     * Set OtherSystemID value
     * @param string $otherSystemID
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryRef
     */
    public function setOtherSystemID($otherSystemID = null)
    {
        $this->OtherSystemID = $otherSystemID;
        return $this;
    }
    /**
     * Get PartitionID value
     * @return string|null
     */
    public function getPartitionID()
    {
        return $this->PartitionID;
    }
    /**
     * Set PartitionID value
     * @param string $partitionID
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryRef
     */
    public function setPartitionID($partitionID = null)
    {
        $this->PartitionID = $partitionID;
        return $this;
    }
    /**
     * Get PrimeHostID value
     * @return string|null
     */
    public function getPrimeHostID()
    {
        return $this->PrimeHostID;
    }
    /**
     * Set PrimeHostID value
     * @param string $primeHostID
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryRef
     */
    public function setPrimeHostID($primeHostID = null)
    {
        $this->PrimeHostID = $primeHostID;
        return $this;
    }
    /**
     * Get TicketingCarrier value
     * @return string|null
     */
    public function getTicketingCarrier()
    {
        return $this->TicketingCarrier;
    }
    /**
     * Set TicketingCarrier value
     * @param string $ticketingCarrier
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryRef
     */
    public function setTicketingCarrier($ticketingCarrier = null)
    {
        $this->TicketingCarrier = $ticketingCarrier;
        return $this;
    }
    /**
     * Get PhaseIVIndicator value
     * @return string|null
     */
    public function getPhaseIVIndicator()
    {
        return $this->PhaseIVIndicator;
    }
    /**
     * Set PhaseIVIndicator value
     * @param string $phaseIVIndicator
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryRef
     */
    public function setPhaseIVIndicator($phaseIVIndicator = null)
    {
        $this->PhaseIVIndicator = $phaseIVIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryRef
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
