<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsuranceDetails Structs
 * @subpackage Structs
 */
class InsuranceDetails extends AbstractStructBase
{
    /**
     * The ConfirmationNumber
     * Meta informations extracted from the WSDL
     * - documentation: "ConfirmationNumber" is used to return the confirmation number associated with the particular insurance segment.
     * - minOccurs: 0
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The Coverage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Coverage
     */
    public $Coverage;
    /**
     * The DestinationLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\DestinationLocation[]
     */
    public $DestinationLocation;
    /**
     * The OriginLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\OriginLocation
     */
    public $OriginLocation;
    /**
     * The Payment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Payment
     */
    public $Payment;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\PersonName[]
     */
    public $PersonName;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: "Text" is used to return specialized instructions associated with the particular insurance segment.
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * The Vendor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Vendor
     */
    public $Vendor;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - documentation: "CurrencyCode" is used to return the insurance premium currency code associated with the particular insurance segment.
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The End
     * Meta informations extracted from the WSDL
     * - documentation: "End" is used to return the end date of the insurance coverage. The formate is MM:DD | A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - use: optional
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $End;
    /**
     * The NumPolicies
     * Meta informations extracted from the WSDL
     * - documentation: "NumPolicies" is used to return the number of policies associated with the particular insurance segment.
     * - use: optional
     * @var string
     */
    public $NumPolicies;
    /**
     * The PlanType
     * Meta informations extracted from the WSDL
     * - documentation: "PlanType" is used to return the insurance plan type.
     * - use: optional
     * @var string
     */
    public $PlanType;
    /**
     * The PremiumAmount
     * Meta informations extracted from the WSDL
     * - documentation: "PremiumAmount" is used to return the insurance premium amount associated with the particular insurance segment.
     * - use: optional
     * @var string
     */
    public $PremiumAmount;
    /**
     * The PurchaseDate
     * Meta informations extracted from the WSDL
     * - documentation: "PurchaseDate" is used to return the purchase date of the insurance. The formate is MM:DD
     * - use: optional
     * @var string
     */
    public $PurchaseDate;
    /**
     * The Start
     * Meta informations extracted from the WSDL
     * - documentation: "Start" is used to return the start date and time of the insurance coverage. The formate is MM:DDTHH:MM | A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - use: optional
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $Start;
    /**
     * The StatusCode
     * Meta informations extracted from the WSDL
     * - documentation: "StatusCode" is used to return the reservation status code.
     * - use: optional
     * @var string
     */
    public $StatusCode;
    /**
     * Constructor method for InsuranceDetails
     * @uses InsuranceDetails::setConfirmationNumber()
     * @uses InsuranceDetails::setCoverage()
     * @uses InsuranceDetails::setDestinationLocation()
     * @uses InsuranceDetails::setOriginLocation()
     * @uses InsuranceDetails::setPayment()
     * @uses InsuranceDetails::setPersonName()
     * @uses InsuranceDetails::setText()
     * @uses InsuranceDetails::setVendor()
     * @uses InsuranceDetails::setCurrencyCode()
     * @uses InsuranceDetails::setEnd()
     * @uses InsuranceDetails::setNumPolicies()
     * @uses InsuranceDetails::setPlanType()
     * @uses InsuranceDetails::setPremiumAmount()
     * @uses InsuranceDetails::setPurchaseDate()
     * @uses InsuranceDetails::setStart()
     * @uses InsuranceDetails::setStatusCode()
     * @param string $confirmationNumber
     * @param \Sabre\PassengerDetailsRQ\Structs\Coverage $coverage
     * @param \Sabre\PassengerDetailsRQ\Structs\DestinationLocation[] $destinationLocation
     * @param \Sabre\PassengerDetailsRQ\Structs\OriginLocation $originLocation
     * @param \Sabre\PassengerDetailsRQ\Structs\Payment $payment
     * @param \Sabre\PassengerDetailsRQ\Structs\PersonName[] $personName
     * @param string $text
     * @param \Sabre\PassengerDetailsRQ\Structs\Vendor $vendor
     * @param string $currencyCode
     * @param string $end
     * @param string $numPolicies
     * @param string $planType
     * @param string $premiumAmount
     * @param string $purchaseDate
     * @param string $start
     * @param string $statusCode
     */
    public function __construct($confirmationNumber = null, \Sabre\PassengerDetailsRQ\Structs\Coverage $coverage = null, array $destinationLocation = array(), \Sabre\PassengerDetailsRQ\Structs\OriginLocation $originLocation = null, \Sabre\PassengerDetailsRQ\Structs\Payment $payment = null, array $personName = array(), $text = null, \Sabre\PassengerDetailsRQ\Structs\Vendor $vendor = null, $currencyCode = null, $end = null, $numPolicies = null, $planType = null, $premiumAmount = null, $purchaseDate = null, $start = null, $statusCode = null)
    {
        $this
            ->setConfirmationNumber($confirmationNumber)
            ->setCoverage($coverage)
            ->setDestinationLocation($destinationLocation)
            ->setOriginLocation($originLocation)
            ->setPayment($payment)
            ->setPersonName($personName)
            ->setText($text)
            ->setVendor($vendor)
            ->setCurrencyCode($currencyCode)
            ->setEnd($end)
            ->setNumPolicies($numPolicies)
            ->setPlanType($planType)
            ->setPremiumAmount($premiumAmount)
            ->setPurchaseDate($purchaseDate)
            ->setStart($start)
            ->setStatusCode($statusCode);
    }
    /**
     * Get ConfirmationNumber value
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @param string $confirmationNumber
     * @return \Sabre\PassengerDetailsRQ\Structs\InsuranceDetails
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Get Coverage value
     * @return \Sabre\PassengerDetailsRQ\Structs\Coverage|null
     */
    public function getCoverage()
    {
        return $this->Coverage;
    }
    /**
     * Set Coverage value
     * @param \Sabre\PassengerDetailsRQ\Structs\Coverage $coverage
     * @return \Sabre\PassengerDetailsRQ\Structs\InsuranceDetails
     */
    public function setCoverage(\Sabre\PassengerDetailsRQ\Structs\Coverage $coverage = null)
    {
        $this->Coverage = $coverage;
        return $this;
    }
    /**
     * Get DestinationLocation value
     * @return \Sabre\PassengerDetailsRQ\Structs\DestinationLocation[]|null
     */
    public function getDestinationLocation()
    {
        return $this->DestinationLocation;
    }
    /**
     * Set DestinationLocation value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\DestinationLocation[] $destinationLocation
     * @return \Sabre\PassengerDetailsRQ\Structs\InsuranceDetails
     */
    public function setDestinationLocation(array $destinationLocation = array())
    {
        $this->DestinationLocation = $destinationLocation;
        return $this;
    }
    /**
     * Add item to DestinationLocation value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\DestinationLocation $item
     * @return \Sabre\PassengerDetailsRQ\Structs\InsuranceDetails
     */
    public function addToDestinationLocation(\Sabre\PassengerDetailsRQ\Structs\DestinationLocation $item)
    {
        $this->DestinationLocation[] = $item;
        return $this;
    }
    /**
     * Get OriginLocation value
     * @return \Sabre\PassengerDetailsRQ\Structs\OriginLocation|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @param \Sabre\PassengerDetailsRQ\Structs\OriginLocation $originLocation
     * @return \Sabre\PassengerDetailsRQ\Structs\InsuranceDetails
     */
    public function setOriginLocation(\Sabre\PassengerDetailsRQ\Structs\OriginLocation $originLocation = null)
    {
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Get Payment value
     * @return \Sabre\PassengerDetailsRQ\Structs\Payment|null
     */
    public function getPayment()
    {
        return $this->Payment;
    }
    /**
     * Set Payment value
     * @param \Sabre\PassengerDetailsRQ\Structs\Payment $payment
     * @return \Sabre\PassengerDetailsRQ\Structs\InsuranceDetails
     */
    public function setPayment(\Sabre\PassengerDetailsRQ\Structs\Payment $payment = null)
    {
        $this->Payment = $payment;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \Sabre\PassengerDetailsRQ\Structs\PersonName[]|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\PersonName[] $personName
     * @return \Sabre\PassengerDetailsRQ\Structs\InsuranceDetails
     */
    public function setPersonName(array $personName = array())
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Add item to PersonName value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\PersonName $item
     * @return \Sabre\PassengerDetailsRQ\Structs\InsuranceDetails
     */
    public function addToPersonName(\Sabre\PassengerDetailsRQ\Structs\PersonName $item)
    {
        $this->PersonName[] = $item;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \Sabre\PassengerDetailsRQ\Structs\InsuranceDetails
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Get Vendor value
     * @return \Sabre\PassengerDetailsRQ\Structs\Vendor|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param \Sabre\PassengerDetailsRQ\Structs\Vendor $vendor
     * @return \Sabre\PassengerDetailsRQ\Structs\InsuranceDetails
     */
    public function setVendor(\Sabre\PassengerDetailsRQ\Structs\Vendor $vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\PassengerDetailsRQ\Structs\InsuranceDetails
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \Sabre\PassengerDetailsRQ\Structs\InsuranceDetails
     */
    public function setEnd($end = null)
    {
        $this->End = $end;
        return $this;
    }
    /**
     * Get NumPolicies value
     * @return string|null
     */
    public function getNumPolicies()
    {
        return $this->NumPolicies;
    }
    /**
     * Set NumPolicies value
     * @param string $numPolicies
     * @return \Sabre\PassengerDetailsRQ\Structs\InsuranceDetails
     */
    public function setNumPolicies($numPolicies = null)
    {
        $this->NumPolicies = $numPolicies;
        return $this;
    }
    /**
     * Get PlanType value
     * @return string|null
     */
    public function getPlanType()
    {
        return $this->PlanType;
    }
    /**
     * Set PlanType value
     * @param string $planType
     * @return \Sabre\PassengerDetailsRQ\Structs\InsuranceDetails
     */
    public function setPlanType($planType = null)
    {
        $this->PlanType = $planType;
        return $this;
    }
    /**
     * Get PremiumAmount value
     * @return string|null
     */
    public function getPremiumAmount()
    {
        return $this->PremiumAmount;
    }
    /**
     * Set PremiumAmount value
     * @param string $premiumAmount
     * @return \Sabre\PassengerDetailsRQ\Structs\InsuranceDetails
     */
    public function setPremiumAmount($premiumAmount = null)
    {
        $this->PremiumAmount = $premiumAmount;
        return $this;
    }
    /**
     * Get PurchaseDate value
     * @return string|null
     */
    public function getPurchaseDate()
    {
        return $this->PurchaseDate;
    }
    /**
     * Set PurchaseDate value
     * @param string $purchaseDate
     * @return \Sabre\PassengerDetailsRQ\Structs\InsuranceDetails
     */
    public function setPurchaseDate($purchaseDate = null)
    {
        $this->PurchaseDate = $purchaseDate;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \Sabre\PassengerDetailsRQ\Structs\InsuranceDetails
     */
    public function setStart($start = null)
    {
        $this->Start = $start;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \Sabre\PassengerDetailsRQ\Structs\InsuranceDetails
     */
    public function setStatusCode($statusCode = null)
    {
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\InsuranceDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
