<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormOfPayment Structs
 * @subpackage Structs
 */
class FormOfPayment extends AbstractStructBase
{
    /**
     * The CreditCard
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\CreditCard
     */
    public $CreditCard;
    /**
     * The Cash
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Cash;
    /**
     * The Check
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Check;
    /**
     * The Voucher
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Voucher;
    /**
     * The Other
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Other;
    /**
     * The transactionID
     * @var string
     */
    public $transactionID;
    /**
     * Constructor method for FormOfPayment
     * @uses FormOfPayment::setCreditCard()
     * @uses FormOfPayment::setCash()
     * @uses FormOfPayment::setCheck()
     * @uses FormOfPayment::setVoucher()
     * @uses FormOfPayment::setOther()
     * @uses FormOfPayment::setTransactionID()
     * @param \Sabre\PassengerDetailsRQ\Structs\CreditCard $creditCard
     * @param string $cash
     * @param string $check
     * @param string $voucher
     * @param string $other
     * @param string $transactionID
     */
    public function __construct(\Sabre\PassengerDetailsRQ\Structs\CreditCard $creditCard = null, $cash = null, $check = null, $voucher = null, $other = null, $transactionID = null)
    {
        $this
            ->setCreditCard($creditCard)
            ->setCash($cash)
            ->setCheck($check)
            ->setVoucher($voucher)
            ->setOther($other)
            ->setTransactionID($transactionID);
    }
    /**
     * Get CreditCard value
     * @return \Sabre\PassengerDetailsRQ\Structs\CreditCard|null
     */
    public function getCreditCard()
    {
        return $this->CreditCard;
    }
    /**
     * Set CreditCard value
     * @param \Sabre\PassengerDetailsRQ\Structs\CreditCard $creditCard
     * @return \Sabre\PassengerDetailsRQ\Structs\FormOfPayment
     */
    public function setCreditCard(\Sabre\PassengerDetailsRQ\Structs\CreditCard $creditCard = null)
    {
        $this->CreditCard = $creditCard;
        return $this;
    }
    /**
     * Get Cash value
     * @return string|null
     */
    public function getCash()
    {
        return $this->Cash;
    }
    /**
     * Set Cash value
     * @param string $cash
     * @return \Sabre\PassengerDetailsRQ\Structs\FormOfPayment
     */
    public function setCash($cash = null)
    {
        $this->Cash = $cash;
        return $this;
    }
    /**
     * Get Check value
     * @return string|null
     */
    public function getCheck()
    {
        return $this->Check;
    }
    /**
     * Set Check value
     * @param string $check
     * @return \Sabre\PassengerDetailsRQ\Structs\FormOfPayment
     */
    public function setCheck($check = null)
    {
        $this->Check = $check;
        return $this;
    }
    /**
     * Get Voucher value
     * @return string|null
     */
    public function getVoucher()
    {
        return $this->Voucher;
    }
    /**
     * Set Voucher value
     * @param string $voucher
     * @return \Sabre\PassengerDetailsRQ\Structs\FormOfPayment
     */
    public function setVoucher($voucher = null)
    {
        $this->Voucher = $voucher;
        return $this;
    }
    /**
     * Get Other value
     * @return string|null
     */
    public function getOther()
    {
        return $this->Other;
    }
    /**
     * Set Other value
     * @param string $other
     * @return \Sabre\PassengerDetailsRQ\Structs\FormOfPayment
     */
    public function setOther($other = null)
    {
        $this->Other = $other;
        return $this;
    }
    /**
     * Get transactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->transactionID;
    }
    /**
     * Set transactionID value
     * @param string $transactionID
     * @return \Sabre\PassengerDetailsRQ\Structs\FormOfPayment
     */
    public function setTransactionID($transactionID = null)
    {
        $this->transactionID = $transactionID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\FormOfPayment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
