<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Email Structs
 * Meta informations extracted from the WSDL
 * - documentation: "Email" is used to return the passenger's email address.
 * @subpackage Structs
 */
class Email extends AbstractStructBase
{
    /**
     * The Ind
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Ind;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Address;
    /**
     * The eTicket
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\ETicket
     */
    public $eTicket;
    /**
     * The Invoice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Invoice
     */
    public $Invoice;
    /**
     * The Itinerary
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Itinerary
     */
    public $Itinerary;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\PersonName
     */
    public $PersonName;
    /**
     * The NameNumber
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $NameNumber;
    /**
     * The ShortText
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ShortText;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Comment;
    /**
     * Constructor method for Email
     * @uses Email::setInd()
     * @uses Email::setAddress()
     * @uses Email::setETicket()
     * @uses Email::setInvoice()
     * @uses Email::setItinerary()
     * @uses Email::setPersonName()
     * @uses Email::setNameNumber()
     * @uses Email::setShortText()
     * @uses Email::setType()
     * @uses Email::set_()
     * @uses Email::setId()
     * @uses Email::setComment()
     * @param bool $ind
     * @param string $address
     * @param \Sabre\PassengerDetailsRQ\Structs\ETicket $eTicket
     * @param \Sabre\PassengerDetailsRQ\Structs\Invoice $invoice
     * @param \Sabre\PassengerDetailsRQ\Structs\Itinerary $itinerary
     * @param \Sabre\PassengerDetailsRQ\Structs\PersonName $personName
     * @param string $nameNumber
     * @param string $shortText
     * @param string $type
     * @param string $_
     * @param string $id
     * @param string $comment
     */
    public function __construct($ind = null, $address = null, \Sabre\PassengerDetailsRQ\Structs\ETicket $eTicket = null, \Sabre\PassengerDetailsRQ\Structs\Invoice $invoice = null, \Sabre\PassengerDetailsRQ\Structs\Itinerary $itinerary = null, \Sabre\PassengerDetailsRQ\Structs\PersonName $personName = null, $nameNumber = null, $shortText = null, $type = null, $_ = null, $id = null, $comment = null)
    {
        $this
            ->setInd($ind)
            ->setAddress($address)
            ->setETicket($eTicket)
            ->setInvoice($invoice)
            ->setItinerary($itinerary)
            ->setPersonName($personName)
            ->setNameNumber($nameNumber)
            ->setShortText($shortText)
            ->setType($type)
            ->set_($_)
            ->setId($id)
            ->setComment($comment);
    }
    /**
     * Get Ind value
     * @return bool
     */
    public function getInd()
    {
        return $this->Ind;
    }
    /**
     * Set Ind value
     * @param bool $ind
     * @return \Sabre\PassengerDetailsRQ\Structs\Email
     */
    public function setInd($ind = null)
    {
        $this->Ind = $ind;
        return $this;
    }
    /**
     * Get Address value
     * @return string
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \Sabre\PassengerDetailsRQ\Structs\Email
     */
    public function setAddress($address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get eTicket value
     * @return \Sabre\PassengerDetailsRQ\Structs\ETicket|null
     */
    public function getETicket()
    {
        return $this->eTicket;
    }
    /**
     * Set eTicket value
     * @param \Sabre\PassengerDetailsRQ\Structs\ETicket $eTicket
     * @return \Sabre\PassengerDetailsRQ\Structs\Email
     */
    public function setETicket(\Sabre\PassengerDetailsRQ\Structs\ETicket $eTicket = null)
    {
        $this->eTicket = $eTicket;
        return $this;
    }
    /**
     * Get Invoice value
     * @return \Sabre\PassengerDetailsRQ\Structs\Invoice|null
     */
    public function getInvoice()
    {
        return $this->Invoice;
    }
    /**
     * Set Invoice value
     * @param \Sabre\PassengerDetailsRQ\Structs\Invoice $invoice
     * @return \Sabre\PassengerDetailsRQ\Structs\Email
     */
    public function setInvoice(\Sabre\PassengerDetailsRQ\Structs\Invoice $invoice = null)
    {
        $this->Invoice = $invoice;
        return $this;
    }
    /**
     * Get Itinerary value
     * @return \Sabre\PassengerDetailsRQ\Structs\Itinerary|null
     */
    public function getItinerary()
    {
        return $this->Itinerary;
    }
    /**
     * Set Itinerary value
     * @param \Sabre\PassengerDetailsRQ\Structs\Itinerary $itinerary
     * @return \Sabre\PassengerDetailsRQ\Structs\Email
     */
    public function setItinerary(\Sabre\PassengerDetailsRQ\Structs\Itinerary $itinerary = null)
    {
        $this->Itinerary = $itinerary;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \Sabre\PassengerDetailsRQ\Structs\PersonName|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \Sabre\PassengerDetailsRQ\Structs\PersonName $personName
     * @return \Sabre\PassengerDetailsRQ\Structs\Email
     */
    public function setPersonName(\Sabre\PassengerDetailsRQ\Structs\PersonName $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get NameNumber value
     * @return string|null
     */
    public function getNameNumber()
    {
        return $this->NameNumber;
    }
    /**
     * Set NameNumber value
     * @param string $nameNumber
     * @return \Sabre\PassengerDetailsRQ\Structs\Email
     */
    public function setNameNumber($nameNumber = null)
    {
        $this->NameNumber = $nameNumber;
        return $this;
    }
    /**
     * Get ShortText value
     * @return string|null
     */
    public function getShortText()
    {
        return $this->ShortText;
    }
    /**
     * Set ShortText value
     * @param string $shortText
     * @return \Sabre\PassengerDetailsRQ\Structs\Email
     */
    public function setShortText($shortText = null)
    {
        $this->ShortText = $shortText;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\PassengerDetailsRQ\Structs\Email
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\PassengerDetailsRQ\Structs\Email
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\PassengerDetailsRQ\Structs\Email
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \Sabre\PassengerDetailsRQ\Structs\Email
     */
    public function setComment($comment = null)
    {
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\Email
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
