<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Duration Structs
 * @subpackage Structs
 */
class Duration extends AbstractStructBase
{
    /**
     * The NumDays
     * Meta informations extracted from the WSDL
     * - documentation: "NumDays" is used to return the number of days associated with the particular tour reservation.
     * - use: optional
     * @var string
     */
    public $NumDays;
    /**
     * Constructor method for Duration
     * @uses Duration::setNumDays()
     * @param string $numDays
     */
    public function __construct($numDays = null)
    {
        $this
            ->setNumDays($numDays);
    }
    /**
     * Get NumDays value
     * @return string|null
     */
    public function getNumDays()
    {
        return $this->NumDays;
    }
    /**
     * Set NumDays value
     * @param string $numDays
     * @return \Sabre\PassengerDetailsRQ\Structs\Duration
     */
    public function setNumDays($numDays = null)
    {
        $this->NumDays = $numDays;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\Duration
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
