<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Document Structs
 * @subpackage Structs
 */
class Document extends AbstractStructBase
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The IssueCountry
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IssueCountry;
    /**
     * The NationalityCountry
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NationalityCountry;
    /**
     * The Visa
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Visa
     */
    public $Visa;
    /**
     * The ExpirationDate
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: A full date type. Accepted format: "yyyy-mm-dd" | A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - pattern: \d{4}-\d{2}-\d{2} |
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $ExpirationDate;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Number;
    /**
     * Constructor method for Document
     * @uses Document::setType()
     * @uses Document::setIssueCountry()
     * @uses Document::setNationalityCountry()
     * @uses Document::setVisa()
     * @uses Document::setExpirationDate()
     * @uses Document::setNumber()
     * @param string $type
     * @param string $issueCountry
     * @param string $nationalityCountry
     * @param \Sabre\PassengerDetailsRQ\Structs\Visa $visa
     * @param string $expirationDate
     * @param string $number
     */
    public function __construct($type = null, $issueCountry = null, $nationalityCountry = null, \Sabre\PassengerDetailsRQ\Structs\Visa $visa = null, $expirationDate = null, $number = null)
    {
        $this
            ->setType($type)
            ->setIssueCountry($issueCountry)
            ->setNationalityCountry($nationalityCountry)
            ->setVisa($visa)
            ->setExpirationDate($expirationDate)
            ->setNumber($number);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\PassengerDetailsRQ\Structs\Document
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get IssueCountry value
     * @return string|null
     */
    public function getIssueCountry()
    {
        return $this->IssueCountry;
    }
    /**
     * Set IssueCountry value
     * @param string $issueCountry
     * @return \Sabre\PassengerDetailsRQ\Structs\Document
     */
    public function setIssueCountry($issueCountry = null)
    {
        $this->IssueCountry = $issueCountry;
        return $this;
    }
    /**
     * Get NationalityCountry value
     * @return string|null
     */
    public function getNationalityCountry()
    {
        return $this->NationalityCountry;
    }
    /**
     * Set NationalityCountry value
     * @param string $nationalityCountry
     * @return \Sabre\PassengerDetailsRQ\Structs\Document
     */
    public function setNationalityCountry($nationalityCountry = null)
    {
        $this->NationalityCountry = $nationalityCountry;
        return $this;
    }
    /**
     * Get Visa value
     * @return \Sabre\PassengerDetailsRQ\Structs\Visa|null
     */
    public function getVisa()
    {
        return $this->Visa;
    }
    /**
     * Set Visa value
     * @param \Sabre\PassengerDetailsRQ\Structs\Visa $visa
     * @return \Sabre\PassengerDetailsRQ\Structs\Document
     */
    public function setVisa(\Sabre\PassengerDetailsRQ\Structs\Visa $visa = null)
    {
        $this->Visa = $visa;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \Sabre\PassengerDetailsRQ\Structs\Document
     */
    public function setExpirationDate($expirationDate = null)
    {
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \Sabre\PassengerDetailsRQ\Structs\Document
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\Document
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
