<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CorporateIDInfo Structs
 * @subpackage Structs
 */
class CorporateIDInfo extends AbstractStructBase
{
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - documentation: Corporation or Agency Number ex. "1234"
     * @var string
     */
    public $Number;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - documentation: Corporation or Agency Name ex. "ABCCORPORATION"
     * @var string
     */
    public $Name;
    /**
     * The primeHost
     * Meta informations extracted from the WSDL
     * - documentation: Owning PrimeHost ID ex. "1S" for Sabre
     * @var string
     */
    public $primeHost;
    /**
     * The prefix
     * Meta informations extracted from the WSDL
     * - documentation: Corporation or Agency qualifier ex. "C"
     * @var string
     */
    public $prefix;
    /**
     * Constructor method for CorporateIDInfo
     * @uses CorporateIDInfo::setNumber()
     * @uses CorporateIDInfo::setName()
     * @uses CorporateIDInfo::setPrimeHost()
     * @uses CorporateIDInfo::setPrefix()
     * @param string $number
     * @param string $name
     * @param string $primeHost
     * @param string $prefix
     */
    public function __construct($number = null, $name = null, $primeHost = null, $prefix = null)
    {
        $this
            ->setNumber($number)
            ->setName($name)
            ->setPrimeHost($primeHost)
            ->setPrefix($prefix);
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \Sabre\PassengerDetailsRQ\Structs\CorporateIDInfo
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Sabre\PassengerDetailsRQ\Structs\CorporateIDInfo
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get primeHost value
     * @return string|null
     */
    public function getPrimeHost()
    {
        return $this->primeHost;
    }
    /**
     * Set primeHost value
     * @param string $primeHost
     * @return \Sabre\PassengerDetailsRQ\Structs\CorporateIDInfo
     */
    public function setPrimeHost($primeHost = null)
    {
        $this->primeHost = $primeHost;
        return $this;
    }
    /**
     * Get prefix value
     * @return string|null
     */
    public function getPrefix()
    {
        return $this->prefix;
    }
    /**
     * Set prefix value
     * @param string $prefix
     * @return \Sabre\PassengerDetailsRQ\Structs\CorporateIDInfo
     */
    public function setPrefix($prefix = null)
    {
        $this->prefix = $prefix;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\CorporateIDInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
