<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseFare Structs
 * Meta informations extracted from the WSDL
 * - documentation: Contains the Base Fare details. Contains the Base Fare amount, applicable currency code and Applicable Percentage Example: Amount="422" CurrencyCode="USD" Percent="0" | "BaseFare" is used to return the Base fare details | "BaseFare"
 * is used to return the Base fare details | "BaseFare" is used to reflect the Base fare details
 * @subpackage Structs
 */
class BaseFare extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: "Amount" is used to return the applicable amount. | "Amount" is used to return the applicable amount. | "Amount" is used to return the applicable amount. | "Amount" is used to return the applicable amount. | "Amount" is used to
     * return the applicable amount. | "Amount" is used to return the applicable amount | "Amount" is used to return the applicable amount | "Amount" is used to return the applicable base fare amount
     * - use: optional
     * @var string
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - documentation: "CurrencyCode" is used to return the applicable currency code. | "CurrencyCode" is used to return the applicable currency code. | "CurrencyCode" is used to return the applicable currency code. | CurrencyCode" is used to return the
     * applicable currency code. | "CurrencyCode" is used to return the applicable currency code | "CurrencyCode" is used to return the applicable currency code
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Percent
     * Meta informations extracted from the WSDL
     * - documentation: "Percent" is used to return the applicable percentage.
     * - use: optional
     * @var string
     */
    public $Percent;
    /**
     * Constructor method for BaseFare
     * @uses BaseFare::setAmount()
     * @uses BaseFare::setCurrencyCode()
     * @uses BaseFare::setPercent()
     * @param string $amount
     * @param string $currencyCode
     * @param string $percent
     */
    public function __construct($amount = null, $currencyCode = null, $percent = null)
    {
        $this
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setPercent($percent);
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\PassengerDetailsRQ\Structs\BaseFare
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\PassengerDetailsRQ\Structs\BaseFare
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Percent value
     * @return string|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param string $percent
     * @return \Sabre\PassengerDetailsRQ\Structs\BaseFare
     */
    public function setPercent($percent = null)
    {
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\BaseFare
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
