<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Vehicle Structs
 * @subpackage Structs
 */
class Vehicle extends AbstractStructBase
{
    /**
     * The ConfirmationNumber
     * Meta informations extracted from the WSDL
     * - documentation: "ConfirmationNumber" is used to return the vehicle rental confirmation number.
     * - minOccurs: 0
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The DirectConnect
     * Meta informations extracted from the WSDL
     * - documentation: "DirectConnect" is used to return miscellaneous direct connect-related information.
     * - minOccurs: 0
     * @var string
     */
    public $DirectConnect;
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\POS
     */
    public $POS;
    /**
     * The VehRentalCore
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\VehRentalCore
     */
    public $VehRentalCore;
    /**
     * The VehVendorAvail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\VehVendorAvail
     */
    public $VehVendorAvail;
    /**
     * The DayOfWeekInd
     * Meta informations extracted from the WSDL
     * - documentation: "DayOfWeekInd" is used to return the day of the week indicator.
     * - use: optional
     * @var string
     */
    public $DayOfWeekInd;
    /**
     * The LinkCode
     * Meta informations extracted from the WSDL
     * - documentation: "LinkCode" is used to return the link code
     * - use: optional
     * @var string
     */
    public $LinkCode;
    /**
     * The MergedSegmentInd
     * Meta informations extracted from the WSDL
     * - documentation: "MergedSegmentInd" is used to return the merged segment indicator associated with the particular itinerary segment if applicable.
     * - use: optional
     * @var string
     */
    public $MergedSegmentInd;
    /**
     * The SegmentNumber
     * Meta informations extracted from the WSDL
     * - documentation: "SegmentNumber" is used to return the itinerary segment number.
     * - use: optional
     * @var string
     */
    public $SegmentNumber;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: "Status" is used to return the status code associated with the particular itinerary segment.
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The IsPast
     * Meta informations extracted from the WSDL
     * - documentation: It returns information if current segment is past or not. Attribute is populated based on Vehicle - VehRentalCore - @ReturnDateTime, Vehicle - VehRentalCore - DropOffLocationDetails - @LocationCode.
     * - use: optional
     * @var bool
     */
    public $IsPast;
    /**
     * Constructor method for Vehicle
     * @uses Vehicle::setConfirmationNumber()
     * @uses Vehicle::setDirectConnect()
     * @uses Vehicle::setPOS()
     * @uses Vehicle::setVehRentalCore()
     * @uses Vehicle::setVehVendorAvail()
     * @uses Vehicle::setDayOfWeekInd()
     * @uses Vehicle::setLinkCode()
     * @uses Vehicle::setMergedSegmentInd()
     * @uses Vehicle::setSegmentNumber()
     * @uses Vehicle::setStatus()
     * @uses Vehicle::setIsPast()
     * @param string $confirmationNumber
     * @param string $directConnect
     * @param \Sabre\PassengerDetailsRQ\Structs\POS $pOS
     * @param \Sabre\PassengerDetailsRQ\Structs\VehRentalCore $vehRentalCore
     * @param \Sabre\PassengerDetailsRQ\Structs\VehVendorAvail $vehVendorAvail
     * @param string $dayOfWeekInd
     * @param string $linkCode
     * @param string $mergedSegmentInd
     * @param string $segmentNumber
     * @param string $status
     * @param bool $isPast
     */
    public function __construct($confirmationNumber = null, $directConnect = null, \Sabre\PassengerDetailsRQ\Structs\POS $pOS = null, \Sabre\PassengerDetailsRQ\Structs\VehRentalCore $vehRentalCore = null, \Sabre\PassengerDetailsRQ\Structs\VehVendorAvail $vehVendorAvail = null, $dayOfWeekInd = null, $linkCode = null, $mergedSegmentInd = null, $segmentNumber = null, $status = null, $isPast = null)
    {
        $this
            ->setConfirmationNumber($confirmationNumber)
            ->setDirectConnect($directConnect)
            ->setPOS($pOS)
            ->setVehRentalCore($vehRentalCore)
            ->setVehVendorAvail($vehVendorAvail)
            ->setDayOfWeekInd($dayOfWeekInd)
            ->setLinkCode($linkCode)
            ->setMergedSegmentInd($mergedSegmentInd)
            ->setSegmentNumber($segmentNumber)
            ->setStatus($status)
            ->setIsPast($isPast);
    }
    /**
     * Get ConfirmationNumber value
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @param string $confirmationNumber
     * @return \Sabre\PassengerDetailsRQ\Structs\Vehicle
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Get DirectConnect value
     * @return string|null
     */
    public function getDirectConnect()
    {
        return $this->DirectConnect;
    }
    /**
     * Set DirectConnect value
     * @param string $directConnect
     * @return \Sabre\PassengerDetailsRQ\Structs\Vehicle
     */
    public function setDirectConnect($directConnect = null)
    {
        $this->DirectConnect = $directConnect;
        return $this;
    }
    /**
     * Get POS value
     * @return \Sabre\PassengerDetailsRQ\Structs\POS|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \Sabre\PassengerDetailsRQ\Structs\POS $pOS
     * @return \Sabre\PassengerDetailsRQ\Structs\Vehicle
     */
    public function setPOS(\Sabre\PassengerDetailsRQ\Structs\POS $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get VehRentalCore value
     * @return \Sabre\PassengerDetailsRQ\Structs\VehRentalCore|null
     */
    public function getVehRentalCore()
    {
        return $this->VehRentalCore;
    }
    /**
     * Set VehRentalCore value
     * @param \Sabre\PassengerDetailsRQ\Structs\VehRentalCore $vehRentalCore
     * @return \Sabre\PassengerDetailsRQ\Structs\Vehicle
     */
    public function setVehRentalCore(\Sabre\PassengerDetailsRQ\Structs\VehRentalCore $vehRentalCore = null)
    {
        $this->VehRentalCore = $vehRentalCore;
        return $this;
    }
    /**
     * Get VehVendorAvail value
     * @return \Sabre\PassengerDetailsRQ\Structs\VehVendorAvail|null
     */
    public function getVehVendorAvail()
    {
        return $this->VehVendorAvail;
    }
    /**
     * Set VehVendorAvail value
     * @param \Sabre\PassengerDetailsRQ\Structs\VehVendorAvail $vehVendorAvail
     * @return \Sabre\PassengerDetailsRQ\Structs\Vehicle
     */
    public function setVehVendorAvail(\Sabre\PassengerDetailsRQ\Structs\VehVendorAvail $vehVendorAvail = null)
    {
        $this->VehVendorAvail = $vehVendorAvail;
        return $this;
    }
    /**
     * Get DayOfWeekInd value
     * @return string|null
     */
    public function getDayOfWeekInd()
    {
        return $this->DayOfWeekInd;
    }
    /**
     * Set DayOfWeekInd value
     * @param string $dayOfWeekInd
     * @return \Sabre\PassengerDetailsRQ\Structs\Vehicle
     */
    public function setDayOfWeekInd($dayOfWeekInd = null)
    {
        $this->DayOfWeekInd = $dayOfWeekInd;
        return $this;
    }
    /**
     * Get LinkCode value
     * @return string|null
     */
    public function getLinkCode()
    {
        return $this->LinkCode;
    }
    /**
     * Set LinkCode value
     * @param string $linkCode
     * @return \Sabre\PassengerDetailsRQ\Structs\Vehicle
     */
    public function setLinkCode($linkCode = null)
    {
        $this->LinkCode = $linkCode;
        return $this;
    }
    /**
     * Get MergedSegmentInd value
     * @return string|null
     */
    public function getMergedSegmentInd()
    {
        return $this->MergedSegmentInd;
    }
    /**
     * Set MergedSegmentInd value
     * @param string $mergedSegmentInd
     * @return \Sabre\PassengerDetailsRQ\Structs\Vehicle
     */
    public function setMergedSegmentInd($mergedSegmentInd = null)
    {
        $this->MergedSegmentInd = $mergedSegmentInd;
        return $this;
    }
    /**
     * Get SegmentNumber value
     * @return string|null
     */
    public function getSegmentNumber()
    {
        return $this->SegmentNumber;
    }
    /**
     * Set SegmentNumber value
     * @param string $segmentNumber
     * @return \Sabre\PassengerDetailsRQ\Structs\Vehicle
     */
    public function setSegmentNumber($segmentNumber = null)
    {
        $this->SegmentNumber = $segmentNumber;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Sabre\PassengerDetailsRQ\Structs\Vehicle
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get IsPast value
     * @return bool|null
     */
    public function getIsPast()
    {
        return $this->IsPast;
    }
    /**
     * Set IsPast value
     * @param bool $isPast
     * @return \Sabre\PassengerDetailsRQ\Structs\Vehicle
     */
    public function setIsPast($isPast = null)
    {
        $this->IsPast = $isPast;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\Vehicle
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
