<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialServiceInfo Structs
 * Meta informations extracted from the WSDL
 * - documentation: "SpecialServiceInfo" hold the SSR details
 * @subpackage Structs
 */
class SpecialServiceInfo extends AbstractStructBase
{
    /**
     * The AdvancePassenger
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\AdvancePassenger[]
     */
    public $AdvancePassenger;
    /**
     * The SecureFlight
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\SecureFlight[]
     */
    public $SecureFlight;
    /**
     * The Service
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Service
     */
    public $Service;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - documentation: "RPH" is used as a reference placeholder
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: "Type" is used to return the type of the SSR segment. Returns the SSR code AFX for Host Airline, GFX for other Airline
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for SpecialServiceInfo
     * @uses SpecialServiceInfo::setAdvancePassenger()
     * @uses SpecialServiceInfo::setSecureFlight()
     * @uses SpecialServiceInfo::setService()
     * @uses SpecialServiceInfo::setRPH()
     * @uses SpecialServiceInfo::setType()
     * @uses SpecialServiceInfo::setId()
     * @param \Sabre\PassengerDetailsRQ\Structs\AdvancePassenger[] $advancePassenger
     * @param \Sabre\PassengerDetailsRQ\Structs\SecureFlight[] $secureFlight
     * @param \Sabre\PassengerDetailsRQ\Structs\Service $service
     * @param string $rPH
     * @param string $type
     * @param string $id
     */
    public function __construct(array $advancePassenger = array(), array $secureFlight = array(), \Sabre\PassengerDetailsRQ\Structs\Service $service = null, $rPH = null, $type = null, $id = null)
    {
        $this
            ->setAdvancePassenger($advancePassenger)
            ->setSecureFlight($secureFlight)
            ->setService($service)
            ->setRPH($rPH)
            ->setType($type)
            ->setId($id);
    }
    /**
     * Get AdvancePassenger value
     * @return \Sabre\PassengerDetailsRQ\Structs\AdvancePassenger[]|null
     */
    public function getAdvancePassenger()
    {
        return $this->AdvancePassenger;
    }
    /**
     * Set AdvancePassenger value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\AdvancePassenger[] $advancePassenger
     * @return \Sabre\PassengerDetailsRQ\Structs\SpecialServiceInfo
     */
    public function setAdvancePassenger(array $advancePassenger = array())
    {
        $this->AdvancePassenger = $advancePassenger;
        return $this;
    }
    /**
     * Add item to AdvancePassenger value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\AdvancePassenger $item
     * @return \Sabre\PassengerDetailsRQ\Structs\SpecialServiceInfo
     */
    public function addToAdvancePassenger(\Sabre\PassengerDetailsRQ\Structs\AdvancePassenger $item)
    {
        $this->AdvancePassenger[] = $item;
        return $this;
    }
    /**
     * Get SecureFlight value
     * @return \Sabre\PassengerDetailsRQ\Structs\SecureFlight[]|null
     */
    public function getSecureFlight()
    {
        return $this->SecureFlight;
    }
    /**
     * Set SecureFlight value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\SecureFlight[] $secureFlight
     * @return \Sabre\PassengerDetailsRQ\Structs\SpecialServiceInfo
     */
    public function setSecureFlight(array $secureFlight = array())
    {
        $this->SecureFlight = $secureFlight;
        return $this;
    }
    /**
     * Add item to SecureFlight value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\SecureFlight $item
     * @return \Sabre\PassengerDetailsRQ\Structs\SpecialServiceInfo
     */
    public function addToSecureFlight(\Sabre\PassengerDetailsRQ\Structs\SecureFlight $item)
    {
        $this->SecureFlight[] = $item;
        return $this;
    }
    /**
     * Get Service value
     * @return \Sabre\PassengerDetailsRQ\Structs\Service|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @param \Sabre\PassengerDetailsRQ\Structs\Service $service
     * @return \Sabre\PassengerDetailsRQ\Structs\SpecialServiceInfo
     */
    public function setService(\Sabre\PassengerDetailsRQ\Structs\Service $service = null)
    {
        $this->Service = $service;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\PassengerDetailsRQ\Structs\SpecialServiceInfo
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\PassengerDetailsRQ\Structs\SpecialServiceInfo
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\PassengerDetailsRQ\Structs\SpecialServiceInfo
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\SpecialServiceInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
