<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SourceType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Provides information on the source of a request. This is from the OTA xsd.
 * @subpackage Structs
 */
class SourceType extends AbstractStructBase
{
    /**
     * The RequestorID
     * Meta informations extracted from the WSDL
     * - documentation: An identifier of the entity making the request (e.g. ATA/IATA/ID number, Electronic Reservation Service Provider (ERSP), Association of British Travel Agents (ABTA)).
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\RequestorIDType
     */
    public $RequestorID;
    /**
     * The BookingChannel
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the booking channel type and whether it is the primary means of connectivity of the source.
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\BookingChannelType
     */
    public $BookingChannel;
    /**
     * The TTYRecordLocator
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\TTYRecordLocatorType[]
     */
    public $TTYRecordLocator;
    /**
     * The OAC
     * Meta informations extracted from the WSDL
     * - documentation: Office Account Code. Defines agency PCC extension
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\OACType
     */
    public $OAC;
    /**
     * The BookingSource
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the booking source within the requesting entity.
     * @var string
     */
    public $BookingSource;
    /**
     * The AgentSine
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the party within the requesting entity.
     * @var string
     */
    public $AgentSine;
    /**
     * The PseudoCityCode
     * Meta informations extracted from the WSDL
     * - documentation: An identification code assigned to an office/agency by a reservation system.
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The ISOCountry
     * Meta informations extracted from the WSDL
     * - documentation: The country code of the requesting party.
     * @var string
     */
    public $ISOCountry;
    /**
     * The ISOCurrency
     * @var string
     */
    public $ISOCurrency;
    /**
     * The AgentDutyCode
     * Meta informations extracted from the WSDL
     * - documentation: An authority code assigned to a requestor.
     * @var string
     */
    public $AgentDutyCode;
    /**
     * The AirlineVendorID
     * Meta informations extracted from the WSDL
     * - documentation: The IATA assigned airline code.
     * @var string
     */
    public $AirlineVendorID;
    /**
     * The AirportCode
     * Meta informations extracted from the WSDL
     * - documentation: The IATA assigned airport code.
     * @var string
     */
    public $AirportCode;
    /**
     * The FirstDepartPoint
     * Meta informations extracted from the WSDL
     * - documentation: The point of first departure in a trip.
     * @var string
     */
    public $FirstDepartPoint;
    /**
     * The SourceSystem
     * Meta informations extracted from the WSDL
     * - documentation: e.g., CSS, CSI
     * @var string
     */
    public $SourceSystem;
    /**
     * The TerminalID
     * Meta informations extracted from the WSDL
     * - documentation: This is the electronic address of the device from which information is entered.
     * @var string
     */
    public $TerminalID;
    /**
     * Constructor method for SourceType
     * @uses SourceType::setRequestorID()
     * @uses SourceType::setBookingChannel()
     * @uses SourceType::setTTYRecordLocator()
     * @uses SourceType::setOAC()
     * @uses SourceType::setBookingSource()
     * @uses SourceType::setAgentSine()
     * @uses SourceType::setPseudoCityCode()
     * @uses SourceType::setISOCountry()
     * @uses SourceType::setISOCurrency()
     * @uses SourceType::setAgentDutyCode()
     * @uses SourceType::setAirlineVendorID()
     * @uses SourceType::setAirportCode()
     * @uses SourceType::setFirstDepartPoint()
     * @uses SourceType::setSourceSystem()
     * @uses SourceType::setTerminalID()
     * @param \Sabre\PassengerDetailsRQ\Structs\RequestorIDType $requestorID
     * @param \Sabre\PassengerDetailsRQ\Structs\BookingChannelType $bookingChannel
     * @param \Sabre\PassengerDetailsRQ\Structs\TTYRecordLocatorType[] $tTYRecordLocator
     * @param \Sabre\PassengerDetailsRQ\Structs\OACType $oAC
     * @param string $bookingSource
     * @param string $agentSine
     * @param string $pseudoCityCode
     * @param string $iSOCountry
     * @param string $iSOCurrency
     * @param string $agentDutyCode
     * @param string $airlineVendorID
     * @param string $airportCode
     * @param string $firstDepartPoint
     * @param string $sourceSystem
     * @param string $terminalID
     */
    public function __construct(\Sabre\PassengerDetailsRQ\Structs\RequestorIDType $requestorID = null, \Sabre\PassengerDetailsRQ\Structs\BookingChannelType $bookingChannel = null, array $tTYRecordLocator = array(), \Sabre\PassengerDetailsRQ\Structs\OACType $oAC = null, $bookingSource = null, $agentSine = null, $pseudoCityCode = null, $iSOCountry = null, $iSOCurrency = null, $agentDutyCode = null, $airlineVendorID = null, $airportCode = null, $firstDepartPoint = null, $sourceSystem = null, $terminalID = null)
    {
        $this
            ->setRequestorID($requestorID)
            ->setBookingChannel($bookingChannel)
            ->setTTYRecordLocator($tTYRecordLocator)
            ->setOAC($oAC)
            ->setBookingSource($bookingSource)
            ->setAgentSine($agentSine)
            ->setPseudoCityCode($pseudoCityCode)
            ->setISOCountry($iSOCountry)
            ->setISOCurrency($iSOCurrency)
            ->setAgentDutyCode($agentDutyCode)
            ->setAirlineVendorID($airlineVendorID)
            ->setAirportCode($airportCode)
            ->setFirstDepartPoint($firstDepartPoint)
            ->setSourceSystem($sourceSystem)
            ->setTerminalID($terminalID);
    }
    /**
     * Get RequestorID value
     * @return \Sabre\PassengerDetailsRQ\Structs\RequestorIDType|null
     */
    public function getRequestorID()
    {
        return $this->RequestorID;
    }
    /**
     * Set RequestorID value
     * @param \Sabre\PassengerDetailsRQ\Structs\RequestorIDType $requestorID
     * @return \Sabre\PassengerDetailsRQ\Structs\SourceType
     */
    public function setRequestorID(\Sabre\PassengerDetailsRQ\Structs\RequestorIDType $requestorID = null)
    {
        $this->RequestorID = $requestorID;
        return $this;
    }
    /**
     * Get BookingChannel value
     * @return \Sabre\PassengerDetailsRQ\Structs\BookingChannelType|null
     */
    public function getBookingChannel()
    {
        return $this->BookingChannel;
    }
    /**
     * Set BookingChannel value
     * @param \Sabre\PassengerDetailsRQ\Structs\BookingChannelType $bookingChannel
     * @return \Sabre\PassengerDetailsRQ\Structs\SourceType
     */
    public function setBookingChannel(\Sabre\PassengerDetailsRQ\Structs\BookingChannelType $bookingChannel = null)
    {
        $this->BookingChannel = $bookingChannel;
        return $this;
    }
    /**
     * Get TTYRecordLocator value
     * @return \Sabre\PassengerDetailsRQ\Structs\TTYRecordLocatorType[]|null
     */
    public function getTTYRecordLocator()
    {
        return $this->TTYRecordLocator;
    }
    /**
     * Set TTYRecordLocator value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\TTYRecordLocatorType[] $tTYRecordLocator
     * @return \Sabre\PassengerDetailsRQ\Structs\SourceType
     */
    public function setTTYRecordLocator(array $tTYRecordLocator = array())
    {
        $this->TTYRecordLocator = $tTYRecordLocator;
        return $this;
    }
    /**
     * Add item to TTYRecordLocator value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\TTYRecordLocatorType $item
     * @return \Sabre\PassengerDetailsRQ\Structs\SourceType
     */
    public function addToTTYRecordLocator(\Sabre\PassengerDetailsRQ\Structs\TTYRecordLocatorType $item)
    {
        $this->TTYRecordLocator[] = $item;
        return $this;
    }
    /**
     * Get OAC value
     * @return \Sabre\PassengerDetailsRQ\Structs\OACType|null
     */
    public function getOAC()
    {
        return $this->OAC;
    }
    /**
     * Set OAC value
     * @param \Sabre\PassengerDetailsRQ\Structs\OACType $oAC
     * @return \Sabre\PassengerDetailsRQ\Structs\SourceType
     */
    public function setOAC(\Sabre\PassengerDetailsRQ\Structs\OACType $oAC = null)
    {
        $this->OAC = $oAC;
        return $this;
    }
    /**
     * Get BookingSource value
     * @return string|null
     */
    public function getBookingSource()
    {
        return $this->BookingSource;
    }
    /**
     * Set BookingSource value
     * @param string $bookingSource
     * @return \Sabre\PassengerDetailsRQ\Structs\SourceType
     */
    public function setBookingSource($bookingSource = null)
    {
        $this->BookingSource = $bookingSource;
        return $this;
    }
    /**
     * Get AgentSine value
     * @return string|null
     */
    public function getAgentSine()
    {
        return $this->AgentSine;
    }
    /**
     * Set AgentSine value
     * @param string $agentSine
     * @return \Sabre\PassengerDetailsRQ\Structs\SourceType
     */
    public function setAgentSine($agentSine = null)
    {
        $this->AgentSine = $agentSine;
        return $this;
    }
    /**
     * Get PseudoCityCode value
     * @return string|null
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \Sabre\PassengerDetailsRQ\Structs\SourceType
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get ISOCountry value
     * @return string|null
     */
    public function getISOCountry()
    {
        return $this->ISOCountry;
    }
    /**
     * Set ISOCountry value
     * @param string $iSOCountry
     * @return \Sabre\PassengerDetailsRQ\Structs\SourceType
     */
    public function setISOCountry($iSOCountry = null)
    {
        $this->ISOCountry = $iSOCountry;
        return $this;
    }
    /**
     * Get ISOCurrency value
     * @return string|null
     */
    public function getISOCurrency()
    {
        return $this->ISOCurrency;
    }
    /**
     * Set ISOCurrency value
     * @param string $iSOCurrency
     * @return \Sabre\PassengerDetailsRQ\Structs\SourceType
     */
    public function setISOCurrency($iSOCurrency = null)
    {
        $this->ISOCurrency = $iSOCurrency;
        return $this;
    }
    /**
     * Get AgentDutyCode value
     * @return string|null
     */
    public function getAgentDutyCode()
    {
        return $this->AgentDutyCode;
    }
    /**
     * Set AgentDutyCode value
     * @param string $agentDutyCode
     * @return \Sabre\PassengerDetailsRQ\Structs\SourceType
     */
    public function setAgentDutyCode($agentDutyCode = null)
    {
        $this->AgentDutyCode = $agentDutyCode;
        return $this;
    }
    /**
     * Get AirlineVendorID value
     * @return string|null
     */
    public function getAirlineVendorID()
    {
        return $this->AirlineVendorID;
    }
    /**
     * Set AirlineVendorID value
     * @param string $airlineVendorID
     * @return \Sabre\PassengerDetailsRQ\Structs\SourceType
     */
    public function setAirlineVendorID($airlineVendorID = null)
    {
        $this->AirlineVendorID = $airlineVendorID;
        return $this;
    }
    /**
     * Get AirportCode value
     * @return string|null
     */
    public function getAirportCode()
    {
        return $this->AirportCode;
    }
    /**
     * Set AirportCode value
     * @param string $airportCode
     * @return \Sabre\PassengerDetailsRQ\Structs\SourceType
     */
    public function setAirportCode($airportCode = null)
    {
        $this->AirportCode = $airportCode;
        return $this;
    }
    /**
     * Get FirstDepartPoint value
     * @return string|null
     */
    public function getFirstDepartPoint()
    {
        return $this->FirstDepartPoint;
    }
    /**
     * Set FirstDepartPoint value
     * @param string $firstDepartPoint
     * @return \Sabre\PassengerDetailsRQ\Structs\SourceType
     */
    public function setFirstDepartPoint($firstDepartPoint = null)
    {
        $this->FirstDepartPoint = $firstDepartPoint;
        return $this;
    }
    /**
     * Get SourceSystem value
     * @return string|null
     */
    public function getSourceSystem()
    {
        return $this->SourceSystem;
    }
    /**
     * Set SourceSystem value
     * @param string $sourceSystem
     * @return \Sabre\PassengerDetailsRQ\Structs\SourceType
     */
    public function setSourceSystem($sourceSystem = null)
    {
        $this->SourceSystem = $sourceSystem;
        return $this;
    }
    /**
     * Get TerminalID value
     * @return string|null
     */
    public function getTerminalID()
    {
        return $this->TerminalID;
    }
    /**
     * Set TerminalID value
     * @param string $terminalID
     * @return \Sabre\PassengerDetailsRQ\Structs\SourceType
     */
    public function setTerminalID($terminalID = null)
    {
        $this->TerminalID = $terminalID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\SourceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
