<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RailType Structs
 * @subpackage Structs
 */
class RailType extends AbstractStructBase
{
    /**
     * The StatusCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The Open
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Open;
    /**
     * The CrossBorder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CrossBorder;
    /**
     * The Duration
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Duration;
    /**
     * The MarketingCarrier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\MarketingCarrier
     */
    public $MarketingCarrier;
    /**
     * The OperatingCarrier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\ServiceProviderType
     */
    public $OperatingCarrier;
    /**
     * The Passengers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Passengers
     */
    public $Passengers;
    /**
     * The SupplementaryServices
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\SupplementaryServices
     */
    public $SupplementaryServices;
    /**
     * The TrainInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\TrainDetailsType
     */
    public $TrainInfo;
    /**
     * The Accommodation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\RailAccommodationType[]
     */
    public $Accommodation;
    /**
     * The StartDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\LocationDetailsType
     */
    public $StartDetails;
    /**
     * The StopDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\LocationDetailsType[]
     */
    public $StopDetails;
    /**
     * The EndDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\LocationDetailsType
     */
    public $EndDetails;
    /**
     * The RailFares
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\RailFareType
     */
    public $RailFares;
    /**
     * The Documents
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Documents
     */
    public $Documents;
    /**
     * The Details
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Details
     */
    public $Details;
    /**
     * Constructor method for RailType
     * @uses RailType::setStatusCode()
     * @uses RailType::setOpen()
     * @uses RailType::setCrossBorder()
     * @uses RailType::setDuration()
     * @uses RailType::setMarketingCarrier()
     * @uses RailType::setOperatingCarrier()
     * @uses RailType::setPassengers()
     * @uses RailType::setSupplementaryServices()
     * @uses RailType::setTrainInfo()
     * @uses RailType::setAccommodation()
     * @uses RailType::setStartDetails()
     * @uses RailType::setStopDetails()
     * @uses RailType::setEndDetails()
     * @uses RailType::setRailFares()
     * @uses RailType::setDocuments()
     * @uses RailType::setDetails()
     * @param string $statusCode
     * @param bool $open
     * @param bool $crossBorder
     * @param string $duration
     * @param \Sabre\PassengerDetailsRQ\Structs\MarketingCarrier $marketingCarrier
     * @param \Sabre\PassengerDetailsRQ\Structs\ServiceProviderType $operatingCarrier
     * @param \Sabre\PassengerDetailsRQ\Structs\Passengers $passengers
     * @param \Sabre\PassengerDetailsRQ\Structs\SupplementaryServices $supplementaryServices
     * @param \Sabre\PassengerDetailsRQ\Structs\TrainDetailsType $trainInfo
     * @param \Sabre\PassengerDetailsRQ\Structs\RailAccommodationType[] $accommodation
     * @param \Sabre\PassengerDetailsRQ\Structs\LocationDetailsType $startDetails
     * @param \Sabre\PassengerDetailsRQ\Structs\LocationDetailsType[] $stopDetails
     * @param \Sabre\PassengerDetailsRQ\Structs\LocationDetailsType $endDetails
     * @param \Sabre\PassengerDetailsRQ\Structs\RailFareType $railFares
     * @param \Sabre\PassengerDetailsRQ\Structs\Documents $documents
     * @param \Sabre\PassengerDetailsRQ\Structs\Details $details
     */
    public function __construct($statusCode = null, $open = null, $crossBorder = null, $duration = null, \Sabre\PassengerDetailsRQ\Structs\MarketingCarrier $marketingCarrier = null, \Sabre\PassengerDetailsRQ\Structs\ServiceProviderType $operatingCarrier = null, \Sabre\PassengerDetailsRQ\Structs\Passengers $passengers = null, \Sabre\PassengerDetailsRQ\Structs\SupplementaryServices $supplementaryServices = null, \Sabre\PassengerDetailsRQ\Structs\TrainDetailsType $trainInfo = null, array $accommodation = array(), \Sabre\PassengerDetailsRQ\Structs\LocationDetailsType $startDetails = null, array $stopDetails = array(), \Sabre\PassengerDetailsRQ\Structs\LocationDetailsType $endDetails = null, \Sabre\PassengerDetailsRQ\Structs\RailFareType $railFares = null, \Sabre\PassengerDetailsRQ\Structs\Documents $documents = null, \Sabre\PassengerDetailsRQ\Structs\Details $details = null)
    {
        $this
            ->setStatusCode($statusCode)
            ->setOpen($open)
            ->setCrossBorder($crossBorder)
            ->setDuration($duration)
            ->setMarketingCarrier($marketingCarrier)
            ->setOperatingCarrier($operatingCarrier)
            ->setPassengers($passengers)
            ->setSupplementaryServices($supplementaryServices)
            ->setTrainInfo($trainInfo)
            ->setAccommodation($accommodation)
            ->setStartDetails($startDetails)
            ->setStopDetails($stopDetails)
            ->setEndDetails($endDetails)
            ->setRailFares($railFares)
            ->setDocuments($documents)
            ->setDetails($details);
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \Sabre\PassengerDetailsRQ\Structs\RailType
     */
    public function setStatusCode($statusCode = null)
    {
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get Open value
     * @return bool|null
     */
    public function getOpen()
    {
        return $this->Open;
    }
    /**
     * Set Open value
     * @param bool $open
     * @return \Sabre\PassengerDetailsRQ\Structs\RailType
     */
    public function setOpen($open = null)
    {
        $this->Open = $open;
        return $this;
    }
    /**
     * Get CrossBorder value
     * @return bool|null
     */
    public function getCrossBorder()
    {
        return $this->CrossBorder;
    }
    /**
     * Set CrossBorder value
     * @param bool $crossBorder
     * @return \Sabre\PassengerDetailsRQ\Structs\RailType
     */
    public function setCrossBorder($crossBorder = null)
    {
        $this->CrossBorder = $crossBorder;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \Sabre\PassengerDetailsRQ\Structs\RailType
     */
    public function setDuration($duration = null)
    {
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get MarketingCarrier value
     * @return \Sabre\PassengerDetailsRQ\Structs\MarketingCarrier|null
     */
    public function getMarketingCarrier()
    {
        return $this->MarketingCarrier;
    }
    /**
     * Set MarketingCarrier value
     * @param \Sabre\PassengerDetailsRQ\Structs\MarketingCarrier $marketingCarrier
     * @return \Sabre\PassengerDetailsRQ\Structs\RailType
     */
    public function setMarketingCarrier(\Sabre\PassengerDetailsRQ\Structs\MarketingCarrier $marketingCarrier = null)
    {
        $this->MarketingCarrier = $marketingCarrier;
        return $this;
    }
    /**
     * Get OperatingCarrier value
     * @return \Sabre\PassengerDetailsRQ\Structs\ServiceProviderType|null
     */
    public function getOperatingCarrier()
    {
        return $this->OperatingCarrier;
    }
    /**
     * Set OperatingCarrier value
     * @param \Sabre\PassengerDetailsRQ\Structs\ServiceProviderType $operatingCarrier
     * @return \Sabre\PassengerDetailsRQ\Structs\RailType
     */
    public function setOperatingCarrier(\Sabre\PassengerDetailsRQ\Structs\ServiceProviderType $operatingCarrier = null)
    {
        $this->OperatingCarrier = $operatingCarrier;
        return $this;
    }
    /**
     * Get Passengers value
     * @return \Sabre\PassengerDetailsRQ\Structs\Passengers|null
     */
    public function getPassengers()
    {
        return $this->Passengers;
    }
    /**
     * Set Passengers value
     * @param \Sabre\PassengerDetailsRQ\Structs\Passengers $passengers
     * @return \Sabre\PassengerDetailsRQ\Structs\RailType
     */
    public function setPassengers(\Sabre\PassengerDetailsRQ\Structs\Passengers $passengers = null)
    {
        $this->Passengers = $passengers;
        return $this;
    }
    /**
     * Get SupplementaryServices value
     * @return \Sabre\PassengerDetailsRQ\Structs\SupplementaryServices|null
     */
    public function getSupplementaryServices()
    {
        return $this->SupplementaryServices;
    }
    /**
     * Set SupplementaryServices value
     * @param \Sabre\PassengerDetailsRQ\Structs\SupplementaryServices $supplementaryServices
     * @return \Sabre\PassengerDetailsRQ\Structs\RailType
     */
    public function setSupplementaryServices(\Sabre\PassengerDetailsRQ\Structs\SupplementaryServices $supplementaryServices = null)
    {
        $this->SupplementaryServices = $supplementaryServices;
        return $this;
    }
    /**
     * Get TrainInfo value
     * @return \Sabre\PassengerDetailsRQ\Structs\TrainDetailsType|null
     */
    public function getTrainInfo()
    {
        return $this->TrainInfo;
    }
    /**
     * Set TrainInfo value
     * @param \Sabre\PassengerDetailsRQ\Structs\TrainDetailsType $trainInfo
     * @return \Sabre\PassengerDetailsRQ\Structs\RailType
     */
    public function setTrainInfo(\Sabre\PassengerDetailsRQ\Structs\TrainDetailsType $trainInfo = null)
    {
        $this->TrainInfo = $trainInfo;
        return $this;
    }
    /**
     * Get Accommodation value
     * @return \Sabre\PassengerDetailsRQ\Structs\RailAccommodationType[]|null
     */
    public function getAccommodation()
    {
        return $this->Accommodation;
    }
    /**
     * Set Accommodation value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\RailAccommodationType[] $accommodation
     * @return \Sabre\PassengerDetailsRQ\Structs\RailType
     */
    public function setAccommodation(array $accommodation = array())
    {
        $this->Accommodation = $accommodation;
        return $this;
    }
    /**
     * Add item to Accommodation value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\RailAccommodationType $item
     * @return \Sabre\PassengerDetailsRQ\Structs\RailType
     */
    public function addToAccommodation(\Sabre\PassengerDetailsRQ\Structs\RailAccommodationType $item)
    {
        $this->Accommodation[] = $item;
        return $this;
    }
    /**
     * Get StartDetails value
     * @return \Sabre\PassengerDetailsRQ\Structs\LocationDetailsType|null
     */
    public function getStartDetails()
    {
        return $this->StartDetails;
    }
    /**
     * Set StartDetails value
     * @param \Sabre\PassengerDetailsRQ\Structs\LocationDetailsType $startDetails
     * @return \Sabre\PassengerDetailsRQ\Structs\RailType
     */
    public function setStartDetails(\Sabre\PassengerDetailsRQ\Structs\LocationDetailsType $startDetails = null)
    {
        $this->StartDetails = $startDetails;
        return $this;
    }
    /**
     * Get StopDetails value
     * @return \Sabre\PassengerDetailsRQ\Structs\LocationDetailsType[]|null
     */
    public function getStopDetails()
    {
        return $this->StopDetails;
    }
    /**
     * Set StopDetails value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\LocationDetailsType[] $stopDetails
     * @return \Sabre\PassengerDetailsRQ\Structs\RailType
     */
    public function setStopDetails(array $stopDetails = array())
    {
        $this->StopDetails = $stopDetails;
        return $this;
    }
    /**
     * Add item to StopDetails value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\LocationDetailsType $item
     * @return \Sabre\PassengerDetailsRQ\Structs\RailType
     */
    public function addToStopDetails(\Sabre\PassengerDetailsRQ\Structs\LocationDetailsType $item)
    {
        $this->StopDetails[] = $item;
        return $this;
    }
    /**
     * Get EndDetails value
     * @return \Sabre\PassengerDetailsRQ\Structs\LocationDetailsType|null
     */
    public function getEndDetails()
    {
        return $this->EndDetails;
    }
    /**
     * Set EndDetails value
     * @param \Sabre\PassengerDetailsRQ\Structs\LocationDetailsType $endDetails
     * @return \Sabre\PassengerDetailsRQ\Structs\RailType
     */
    public function setEndDetails(\Sabre\PassengerDetailsRQ\Structs\LocationDetailsType $endDetails = null)
    {
        $this->EndDetails = $endDetails;
        return $this;
    }
    /**
     * Get RailFares value
     * @return \Sabre\PassengerDetailsRQ\Structs\RailFareType|null
     */
    public function getRailFares()
    {
        return $this->RailFares;
    }
    /**
     * Set RailFares value
     * @param \Sabre\PassengerDetailsRQ\Structs\RailFareType $railFares
     * @return \Sabre\PassengerDetailsRQ\Structs\RailType
     */
    public function setRailFares(\Sabre\PassengerDetailsRQ\Structs\RailFareType $railFares = null)
    {
        $this->RailFares = $railFares;
        return $this;
    }
    /**
     * Get Documents value
     * @return \Sabre\PassengerDetailsRQ\Structs\Documents|null
     */
    public function getDocuments()
    {
        return $this->Documents;
    }
    /**
     * Set Documents value
     * @param \Sabre\PassengerDetailsRQ\Structs\Documents $documents
     * @return \Sabre\PassengerDetailsRQ\Structs\RailType
     */
    public function setDocuments(\Sabre\PassengerDetailsRQ\Structs\Documents $documents = null)
    {
        $this->Documents = $documents;
        return $this;
    }
    /**
     * Get Details value
     * @return \Sabre\PassengerDetailsRQ\Structs\Details|null
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * Set Details value
     * @param \Sabre\PassengerDetailsRQ\Structs\Details $details
     * @return \Sabre\PassengerDetailsRQ\Structs\RailType
     */
    public function setDetails(\Sabre\PassengerDetailsRQ\Structs\Details $details = null)
    {
        $this->Details = $details;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\RailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
