<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Rail Structs
 * @subpackage Structs
 */
class Rail extends AbstractStructBase
{
    /**
     * The ConfirmationNumber
     * Meta informations extracted from the WSDL
     * - documentation: "ConfirmationNumber" is used to return the confirmation number associated with the particular rail segment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ConfirmationNumber;
    /**
     * The DestinationLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\DestinationLocation
     */
    public $DestinationLocation;
    /**
     * The IssueDate
     * Meta informations extracted from the WSDL
     * - documentation: "IssueDate" is used to return ticket issue date-related information. "IssueDate" follows this format: MM:DD
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $IssueDate;
    /**
     * The OriginLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\OriginLocation
     */
    public $OriginLocation;
    /**
     * The ServiceInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\ServiceInformation
     */
    public $ServiceInformation;
    /**
     * The SNCF_Information
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\SNCF_Information
     */
    public $SNCF_Information;
    /**
     * The SpaceReserved
     * Meta informations extracted from the WSDL
     * - documentation: "SpaceReserved" is used to return space reserved-related information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $SpaceReserved;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: "Text" is used to return miscellaneous rail-related information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Text;
    /**
     * The TicketControlNumber
     * Meta informations extracted from the WSDL
     * - documentation: "TicketControlNumber" is used to return ticket control number-related information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $TicketControlNumber;
    /**
     * The Train
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Train[]
     */
    public $Train;
    /**
     * The Vendor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Vendor
     */
    public $Vendor;
    /**
     * The DayOfWeekInd
     * Meta informations extracted from the WSDL
     * - documentation: "DayOfWeekInd" is used to return the day of the week indicator.
     * - use: optional
     * @var string
     */
    public $DayOfWeekInd;
    /**
     * The LinkCode
     * Meta informations extracted from the WSDL
     * - documentation: "LinkCode" is used to return the link code
     * - use: optional
     * @var string
     */
    public $LinkCode;
    /**
     * The MergedSegmentInd
     * Meta informations extracted from the WSDL
     * - documentation: "MergedSegmentInd" is used to return the merged segment indicator associated with the particular rail segment if applicable.
     * - use: optional
     * @var string
     */
    public $MergedSegmentInd;
    /**
     * The NumberInParty
     * Meta informations extracted from the WSDL
     * - documentation: "NumberInParty" is used to return the number of passengers associated with the particular rail segment.
     * - use: optional
     * @var string
     */
    public $NumberInParty;
    /**
     * The ResBookDesigCode
     * Meta informations extracted from the WSDL
     * - documentation: "ResBookDesigCode" is used to return the booking class associated with the particular rail segment.
     * - use: optional
     * @var string
     */
    public $ResBookDesigCode;
    /**
     * The SegmentNumber
     * Meta informations extracted from the WSDL
     * - documentation: "SegmentNumber" is used to return the itinerary segment number.
     * - use: optional
     * @var string
     */
    public $SegmentNumber;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: "Status" is used to return the status code associated with the particular itinerary segment.
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: "Type" is used to return the type of segment.
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The IsPast
     * Meta informations extracted from the WSDL
     * - documentation: It returns information if current segment is past or not. Attribute is populated based on Rail - OriginLocation - DepartureDate, Rail - OriginLocation - DepartureTime, Rail - OriginLocation - @LocationCode. There is end date included
     * in schema, but it is never populated, this is why origin departure time and origin location will consider.
     * - use: optional
     * @var bool
     */
    public $IsPast;
    /**
     * Constructor method for Rail
     * @uses Rail::setConfirmationNumber()
     * @uses Rail::setDestinationLocation()
     * @uses Rail::setIssueDate()
     * @uses Rail::setOriginLocation()
     * @uses Rail::setServiceInformation()
     * @uses Rail::setSNCF_Information()
     * @uses Rail::setSpaceReserved()
     * @uses Rail::setText()
     * @uses Rail::setTicketControlNumber()
     * @uses Rail::setTrain()
     * @uses Rail::setVendor()
     * @uses Rail::setDayOfWeekInd()
     * @uses Rail::setLinkCode()
     * @uses Rail::setMergedSegmentInd()
     * @uses Rail::setNumberInParty()
     * @uses Rail::setResBookDesigCode()
     * @uses Rail::setSegmentNumber()
     * @uses Rail::setStatus()
     * @uses Rail::setType()
     * @uses Rail::setIsPast()
     * @param string[] $confirmationNumber
     * @param \Sabre\PassengerDetailsRQ\Structs\DestinationLocation $destinationLocation
     * @param string[] $issueDate
     * @param \Sabre\PassengerDetailsRQ\Structs\OriginLocation $originLocation
     * @param \Sabre\PassengerDetailsRQ\Structs\ServiceInformation $serviceInformation
     * @param \Sabre\PassengerDetailsRQ\Structs\SNCF_Information $sNCF_Information
     * @param string[] $spaceReserved
     * @param string[] $text
     * @param string[] $ticketControlNumber
     * @param \Sabre\PassengerDetailsRQ\Structs\Train[] $train
     * @param \Sabre\PassengerDetailsRQ\Structs\Vendor $vendor
     * @param string $dayOfWeekInd
     * @param string $linkCode
     * @param string $mergedSegmentInd
     * @param string $numberInParty
     * @param string $resBookDesigCode
     * @param string $segmentNumber
     * @param string $status
     * @param string $type
     * @param bool $isPast
     */
    public function __construct(array $confirmationNumber = array(), \Sabre\PassengerDetailsRQ\Structs\DestinationLocation $destinationLocation = null, array $issueDate = array(), \Sabre\PassengerDetailsRQ\Structs\OriginLocation $originLocation = null, \Sabre\PassengerDetailsRQ\Structs\ServiceInformation $serviceInformation = null, \Sabre\PassengerDetailsRQ\Structs\SNCF_Information $sNCF_Information = null, array $spaceReserved = array(), array $text = array(), array $ticketControlNumber = array(), array $train = array(), \Sabre\PassengerDetailsRQ\Structs\Vendor $vendor = null, $dayOfWeekInd = null, $linkCode = null, $mergedSegmentInd = null, $numberInParty = null, $resBookDesigCode = null, $segmentNumber = null, $status = null, $type = null, $isPast = null)
    {
        $this
            ->setConfirmationNumber($confirmationNumber)
            ->setDestinationLocation($destinationLocation)
            ->setIssueDate($issueDate)
            ->setOriginLocation($originLocation)
            ->setServiceInformation($serviceInformation)
            ->setSNCF_Information($sNCF_Information)
            ->setSpaceReserved($spaceReserved)
            ->setText($text)
            ->setTicketControlNumber($ticketControlNumber)
            ->setTrain($train)
            ->setVendor($vendor)
            ->setDayOfWeekInd($dayOfWeekInd)
            ->setLinkCode($linkCode)
            ->setMergedSegmentInd($mergedSegmentInd)
            ->setNumberInParty($numberInParty)
            ->setResBookDesigCode($resBookDesigCode)
            ->setSegmentNumber($segmentNumber)
            ->setStatus($status)
            ->setType($type)
            ->setIsPast($isPast);
    }
    /**
     * Get ConfirmationNumber value
     * @return string[]|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @throws \InvalidArgumentException
     * @param string[] $confirmationNumber
     * @return \Sabre\PassengerDetailsRQ\Structs\Rail
     */
    public function setConfirmationNumber(array $confirmationNumber = array())
    {
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Add item to ConfirmationNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\PassengerDetailsRQ\Structs\Rail
     */
    public function addToConfirmationNumber($item)
    {
        $this->ConfirmationNumber[] = $item;
        return $this;
    }
    /**
     * Get DestinationLocation value
     * @return \Sabre\PassengerDetailsRQ\Structs\DestinationLocation|null
     */
    public function getDestinationLocation()
    {
        return $this->DestinationLocation;
    }
    /**
     * Set DestinationLocation value
     * @param \Sabre\PassengerDetailsRQ\Structs\DestinationLocation $destinationLocation
     * @return \Sabre\PassengerDetailsRQ\Structs\Rail
     */
    public function setDestinationLocation(\Sabre\PassengerDetailsRQ\Structs\DestinationLocation $destinationLocation = null)
    {
        $this->DestinationLocation = $destinationLocation;
        return $this;
    }
    /**
     * Get IssueDate value
     * @return string[]|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @throws \InvalidArgumentException
     * @param string[] $issueDate
     * @return \Sabre\PassengerDetailsRQ\Structs\Rail
     */
    public function setIssueDate(array $issueDate = array())
    {
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Add item to IssueDate value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\PassengerDetailsRQ\Structs\Rail
     */
    public function addToIssueDate($item)
    {
        $this->IssueDate[] = $item;
        return $this;
    }
    /**
     * Get OriginLocation value
     * @return \Sabre\PassengerDetailsRQ\Structs\OriginLocation|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @param \Sabre\PassengerDetailsRQ\Structs\OriginLocation $originLocation
     * @return \Sabre\PassengerDetailsRQ\Structs\Rail
     */
    public function setOriginLocation(\Sabre\PassengerDetailsRQ\Structs\OriginLocation $originLocation = null)
    {
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Get ServiceInformation value
     * @return \Sabre\PassengerDetailsRQ\Structs\ServiceInformation|null
     */
    public function getServiceInformation()
    {
        return $this->ServiceInformation;
    }
    /**
     * Set ServiceInformation value
     * @param \Sabre\PassengerDetailsRQ\Structs\ServiceInformation $serviceInformation
     * @return \Sabre\PassengerDetailsRQ\Structs\Rail
     */
    public function setServiceInformation(\Sabre\PassengerDetailsRQ\Structs\ServiceInformation $serviceInformation = null)
    {
        $this->ServiceInformation = $serviceInformation;
        return $this;
    }
    /**
     * Get SNCF_Information value
     * @return \Sabre\PassengerDetailsRQ\Structs\SNCF_Information|null
     */
    public function getSNCF_Information()
    {
        return $this->SNCF_Information;
    }
    /**
     * Set SNCF_Information value
     * @param \Sabre\PassengerDetailsRQ\Structs\SNCF_Information $sNCF_Information
     * @return \Sabre\PassengerDetailsRQ\Structs\Rail
     */
    public function setSNCF_Information(\Sabre\PassengerDetailsRQ\Structs\SNCF_Information $sNCF_Information = null)
    {
        $this->SNCF_Information = $sNCF_Information;
        return $this;
    }
    /**
     * Get SpaceReserved value
     * @return string[]|null
     */
    public function getSpaceReserved()
    {
        return $this->SpaceReserved;
    }
    /**
     * Set SpaceReserved value
     * @throws \InvalidArgumentException
     * @param string[] $spaceReserved
     * @return \Sabre\PassengerDetailsRQ\Structs\Rail
     */
    public function setSpaceReserved(array $spaceReserved = array())
    {
        $this->SpaceReserved = $spaceReserved;
        return $this;
    }
    /**
     * Add item to SpaceReserved value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\PassengerDetailsRQ\Structs\Rail
     */
    public function addToSpaceReserved($item)
    {
        $this->SpaceReserved[] = $item;
        return $this;
    }
    /**
     * Get Text value
     * @return string[]|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @throws \InvalidArgumentException
     * @param string[] $text
     * @return \Sabre\PassengerDetailsRQ\Structs\Rail
     */
    public function setText(array $text = array())
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Add item to Text value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\PassengerDetailsRQ\Structs\Rail
     */
    public function addToText($item)
    {
        $this->Text[] = $item;
        return $this;
    }
    /**
     * Get TicketControlNumber value
     * @return string[]|null
     */
    public function getTicketControlNumber()
    {
        return $this->TicketControlNumber;
    }
    /**
     * Set TicketControlNumber value
     * @throws \InvalidArgumentException
     * @param string[] $ticketControlNumber
     * @return \Sabre\PassengerDetailsRQ\Structs\Rail
     */
    public function setTicketControlNumber(array $ticketControlNumber = array())
    {
        $this->TicketControlNumber = $ticketControlNumber;
        return $this;
    }
    /**
     * Add item to TicketControlNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\PassengerDetailsRQ\Structs\Rail
     */
    public function addToTicketControlNumber($item)
    {
        $this->TicketControlNumber[] = $item;
        return $this;
    }
    /**
     * Get Train value
     * @return \Sabre\PassengerDetailsRQ\Structs\Train[]|null
     */
    public function getTrain()
    {
        return $this->Train;
    }
    /**
     * Set Train value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\Train[] $train
     * @return \Sabre\PassengerDetailsRQ\Structs\Rail
     */
    public function setTrain(array $train = array())
    {
        $this->Train = $train;
        return $this;
    }
    /**
     * Add item to Train value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\Train $item
     * @return \Sabre\PassengerDetailsRQ\Structs\Rail
     */
    public function addToTrain(\Sabre\PassengerDetailsRQ\Structs\Train $item)
    {
        $this->Train[] = $item;
        return $this;
    }
    /**
     * Get Vendor value
     * @return \Sabre\PassengerDetailsRQ\Structs\Vendor|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param \Sabre\PassengerDetailsRQ\Structs\Vendor $vendor
     * @return \Sabre\PassengerDetailsRQ\Structs\Rail
     */
    public function setVendor(\Sabre\PassengerDetailsRQ\Structs\Vendor $vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Get DayOfWeekInd value
     * @return string|null
     */
    public function getDayOfWeekInd()
    {
        return $this->DayOfWeekInd;
    }
    /**
     * Set DayOfWeekInd value
     * @param string $dayOfWeekInd
     * @return \Sabre\PassengerDetailsRQ\Structs\Rail
     */
    public function setDayOfWeekInd($dayOfWeekInd = null)
    {
        $this->DayOfWeekInd = $dayOfWeekInd;
        return $this;
    }
    /**
     * Get LinkCode value
     * @return string|null
     */
    public function getLinkCode()
    {
        return $this->LinkCode;
    }
    /**
     * Set LinkCode value
     * @param string $linkCode
     * @return \Sabre\PassengerDetailsRQ\Structs\Rail
     */
    public function setLinkCode($linkCode = null)
    {
        $this->LinkCode = $linkCode;
        return $this;
    }
    /**
     * Get MergedSegmentInd value
     * @return string|null
     */
    public function getMergedSegmentInd()
    {
        return $this->MergedSegmentInd;
    }
    /**
     * Set MergedSegmentInd value
     * @param string $mergedSegmentInd
     * @return \Sabre\PassengerDetailsRQ\Structs\Rail
     */
    public function setMergedSegmentInd($mergedSegmentInd = null)
    {
        $this->MergedSegmentInd = $mergedSegmentInd;
        return $this;
    }
    /**
     * Get NumberInParty value
     * @return string|null
     */
    public function getNumberInParty()
    {
        return $this->NumberInParty;
    }
    /**
     * Set NumberInParty value
     * @param string $numberInParty
     * @return \Sabre\PassengerDetailsRQ\Structs\Rail
     */
    public function setNumberInParty($numberInParty = null)
    {
        $this->NumberInParty = $numberInParty;
        return $this;
    }
    /**
     * Get ResBookDesigCode value
     * @return string|null
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @param string $resBookDesigCode
     * @return \Sabre\PassengerDetailsRQ\Structs\Rail
     */
    public function setResBookDesigCode($resBookDesigCode = null)
    {
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Get SegmentNumber value
     * @return string|null
     */
    public function getSegmentNumber()
    {
        return $this->SegmentNumber;
    }
    /**
     * Set SegmentNumber value
     * @param string $segmentNumber
     * @return \Sabre\PassengerDetailsRQ\Structs\Rail
     */
    public function setSegmentNumber($segmentNumber = null)
    {
        $this->SegmentNumber = $segmentNumber;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Sabre\PassengerDetailsRQ\Structs\Rail
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\PassengerDetailsRQ\Structs\Rail
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get IsPast value
     * @return bool|null
     */
    public function getIsPast()
    {
        return $this->IsPast;
    }
    /**
     * Set IsPast value
     * @param bool $isPast
     * @return \Sabre\PassengerDetailsRQ\Structs\Rail
     */
    public function setIsPast($isPast = null)
    {
        $this->IsPast = $isPast;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\Rail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
