<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductBaseType Structs
 * @subpackage Structs
 */
class ProductBaseType extends AbstractStructBase
{
    /**
     * The ProductType
     * @var string
     */
    public $ProductType;
    /**
     * The VendorCode
     * @var string
     */
    public $VendorCode;
    /**
     * The StatusCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The StartPoint
     * @var string
     */
    public $StartPoint;
    /**
     * The StartDateTime
     * Meta informations extracted from the WSDL
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $StartDateTime;
    /**
     * The EndPoint
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EndPoint;
    /**
     * The EndDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $EndDateTime;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var string[]
     */
    public $Text;
    /**
     * The SegmentReference
     * @var int
     */
    public $SegmentReference;
    /**
     * Constructor method for ProductBaseType
     * @uses ProductBaseType::setProductType()
     * @uses ProductBaseType::setVendorCode()
     * @uses ProductBaseType::setStatusCode()
     * @uses ProductBaseType::setStartPoint()
     * @uses ProductBaseType::setStartDateTime()
     * @uses ProductBaseType::setEndPoint()
     * @uses ProductBaseType::setEndDateTime()
     * @uses ProductBaseType::setText()
     * @uses ProductBaseType::setSegmentReference()
     * @param string $productType
     * @param string $vendorCode
     * @param string $statusCode
     * @param string $startPoint
     * @param string $startDateTime
     * @param string $endPoint
     * @param string $endDateTime
     * @param string[] $text
     * @param int $segmentReference
     */
    public function __construct($productType = null, $vendorCode = null, $statusCode = null, $startPoint = null, $startDateTime = null, $endPoint = null, $endDateTime = null, array $text = array(), $segmentReference = null)
    {
        $this
            ->setProductType($productType)
            ->setVendorCode($vendorCode)
            ->setStatusCode($statusCode)
            ->setStartPoint($startPoint)
            ->setStartDateTime($startDateTime)
            ->setEndPoint($endPoint)
            ->setEndDateTime($endDateTime)
            ->setText($text)
            ->setSegmentReference($segmentReference);
    }
    /**
     * Get ProductType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @param string $productType
     * @return \Sabre\PassengerDetailsRQ\Structs\ProductBaseType
     */
    public function setProductType($productType = null)
    {
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Get VendorCode value
     * @return string|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * Set VendorCode value
     * @param string $vendorCode
     * @return \Sabre\PassengerDetailsRQ\Structs\ProductBaseType
     */
    public function setVendorCode($vendorCode = null)
    {
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \Sabre\PassengerDetailsRQ\Structs\ProductBaseType
     */
    public function setStatusCode($statusCode = null)
    {
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get StartPoint value
     * @return string|null
     */
    public function getStartPoint()
    {
        return $this->StartPoint;
    }
    /**
     * Set StartPoint value
     * @param string $startPoint
     * @return \Sabre\PassengerDetailsRQ\Structs\ProductBaseType
     */
    public function setStartPoint($startPoint = null)
    {
        $this->StartPoint = $startPoint;
        return $this;
    }
    /**
     * Get StartDateTime value
     * @return string|null
     */
    public function getStartDateTime()
    {
        return $this->StartDateTime;
    }
    /**
     * Set StartDateTime value
     * @param string $startDateTime
     * @return \Sabre\PassengerDetailsRQ\Structs\ProductBaseType
     */
    public function setStartDateTime($startDateTime = null)
    {
        $this->StartDateTime = $startDateTime;
        return $this;
    }
    /**
     * Get EndPoint value
     * @return string|null
     */
    public function getEndPoint()
    {
        return $this->EndPoint;
    }
    /**
     * Set EndPoint value
     * @param string $endPoint
     * @return \Sabre\PassengerDetailsRQ\Structs\ProductBaseType
     */
    public function setEndPoint($endPoint = null)
    {
        $this->EndPoint = $endPoint;
        return $this;
    }
    /**
     * Get EndDateTime value
     * @return string|null
     */
    public function getEndDateTime()
    {
        return $this->EndDateTime;
    }
    /**
     * Set EndDateTime value
     * @param string $endDateTime
     * @return \Sabre\PassengerDetailsRQ\Structs\ProductBaseType
     */
    public function setEndDateTime($endDateTime = null)
    {
        $this->EndDateTime = $endDateTime;
        return $this;
    }
    /**
     * Get Text value
     * @return string[]|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @throws \InvalidArgumentException
     * @param string[] $text
     * @return \Sabre\PassengerDetailsRQ\Structs\ProductBaseType
     */
    public function setText(array $text = array())
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Add item to Text value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\PassengerDetailsRQ\Structs\ProductBaseType
     */
    public function addToText($item)
    {
        $this->Text[] = $item;
        return $this;
    }
    /**
     * Get SegmentReference value
     * @return int|null
     */
    public function getSegmentReference()
    {
        return $this->SegmentReference;
    }
    /**
     * Set SegmentReference value
     * @param int $segmentReference
     * @return \Sabre\PassengerDetailsRQ\Structs\ProductBaseType
     */
    public function setSegmentReference($segmentReference = null)
    {
        $this->SegmentReference = $segmentReference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\ProductBaseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
