<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceQuote Structs
 * @subpackage Structs
 */
class PriceQuote extends AbstractStructBase
{
    /**
     * The MiscInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\MiscInformation
     */
    public $MiscInformation;
    /**
     * The PricedItinerary
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\PricedItinerary[]
     */
    public $PricedItinerary;
    /**
     * The ResponseHeader
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\ResponseHeader
     */
    public $ResponseHeader;
    /**
     * The PriceQuotePlus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\PriceQuotePlus
     */
    public $PriceQuotePlus;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - documentation: "RPH" is used as a reference placeholder.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for PriceQuote
     * @uses PriceQuote::setMiscInformation()
     * @uses PriceQuote::setPricedItinerary()
     * @uses PriceQuote::setResponseHeader()
     * @uses PriceQuote::setPriceQuotePlus()
     * @uses PriceQuote::setRPH()
     * @param \Sabre\PassengerDetailsRQ\Structs\MiscInformation $miscInformation
     * @param \Sabre\PassengerDetailsRQ\Structs\PricedItinerary[] $pricedItinerary
     * @param \Sabre\PassengerDetailsRQ\Structs\ResponseHeader $responseHeader
     * @param \Sabre\PassengerDetailsRQ\Structs\PriceQuotePlus $priceQuotePlus
     * @param string $rPH
     */
    public function __construct(\Sabre\PassengerDetailsRQ\Structs\MiscInformation $miscInformation = null, array $pricedItinerary = array(), \Sabre\PassengerDetailsRQ\Structs\ResponseHeader $responseHeader = null, \Sabre\PassengerDetailsRQ\Structs\PriceQuotePlus $priceQuotePlus = null, $rPH = null)
    {
        $this
            ->setMiscInformation($miscInformation)
            ->setPricedItinerary($pricedItinerary)
            ->setResponseHeader($responseHeader)
            ->setPriceQuotePlus($priceQuotePlus)
            ->setRPH($rPH);
    }
    /**
     * Get MiscInformation value
     * @return \Sabre\PassengerDetailsRQ\Structs\MiscInformation|null
     */
    public function getMiscInformation()
    {
        return $this->MiscInformation;
    }
    /**
     * Set MiscInformation value
     * @param \Sabre\PassengerDetailsRQ\Structs\MiscInformation $miscInformation
     * @return \Sabre\PassengerDetailsRQ\Structs\PriceQuote
     */
    public function setMiscInformation(\Sabre\PassengerDetailsRQ\Structs\MiscInformation $miscInformation = null)
    {
        $this->MiscInformation = $miscInformation;
        return $this;
    }
    /**
     * Get PricedItinerary value
     * @return \Sabre\PassengerDetailsRQ\Structs\PricedItinerary[]|null
     */
    public function getPricedItinerary()
    {
        return $this->PricedItinerary;
    }
    /**
     * Set PricedItinerary value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\PricedItinerary[] $pricedItinerary
     * @return \Sabre\PassengerDetailsRQ\Structs\PriceQuote
     */
    public function setPricedItinerary(array $pricedItinerary = array())
    {
        $this->PricedItinerary = $pricedItinerary;
        return $this;
    }
    /**
     * Add item to PricedItinerary value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\PricedItinerary $item
     * @return \Sabre\PassengerDetailsRQ\Structs\PriceQuote
     */
    public function addToPricedItinerary(\Sabre\PassengerDetailsRQ\Structs\PricedItinerary $item)
    {
        $this->PricedItinerary[] = $item;
        return $this;
    }
    /**
     * Get ResponseHeader value
     * @return \Sabre\PassengerDetailsRQ\Structs\ResponseHeader|null
     */
    public function getResponseHeader()
    {
        return $this->ResponseHeader;
    }
    /**
     * Set ResponseHeader value
     * @param \Sabre\PassengerDetailsRQ\Structs\ResponseHeader $responseHeader
     * @return \Sabre\PassengerDetailsRQ\Structs\PriceQuote
     */
    public function setResponseHeader(\Sabre\PassengerDetailsRQ\Structs\ResponseHeader $responseHeader = null)
    {
        $this->ResponseHeader = $responseHeader;
        return $this;
    }
    /**
     * Get PriceQuotePlus value
     * @return \Sabre\PassengerDetailsRQ\Structs\PriceQuotePlus|null
     */
    public function getPriceQuotePlus()
    {
        return $this->PriceQuotePlus;
    }
    /**
     * Set PriceQuotePlus value
     * @param \Sabre\PassengerDetailsRQ\Structs\PriceQuotePlus $priceQuotePlus
     * @return \Sabre\PassengerDetailsRQ\Structs\PriceQuote
     */
    public function setPriceQuotePlus(\Sabre\PassengerDetailsRQ\Structs\PriceQuotePlus $priceQuotePlus = null)
    {
        $this->PriceQuotePlus = $priceQuotePlus;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\PassengerDetailsRQ\Structs\PriceQuote
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\PriceQuote
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
