<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Placement Structs
 * Meta informations extracted from the WSDL
 * - documentation: "Placement" is used to return queue placement-related information associated with the particular record if applicable
 * @subpackage Structs
 */
class Placement extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - documentation: "Placement" is used to return queue placement-related information associated with the particular record if applicable
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * The Coach
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Sabre\PassengerDetailsRQ\Structs\Coach[]
     */
    public $Coach;
    /**
     * The Detail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Detail;
    /**
     * The code
     * @var string
     */
    public $code;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * Constructor method for Placement
     * @uses Placement::set_()
     * @uses Placement::setRPH()
     * @uses Placement::setId()
     * @uses Placement::setCoach()
     * @uses Placement::setDetail()
     * @uses Placement::setCode()
     * @uses Placement::setType()
     * @param string $_
     * @param string $rPH
     * @param string $id
     * @param \Sabre\PassengerDetailsRQ\Structs\Coach[] $coach
     * @param string[] $detail
     * @param string $code
     * @param string $type
     */
    public function __construct($_ = null, $rPH = null, $id = null, array $coach = array(), array $detail = array(), $code = null, $type = null)
    {
        $this
            ->set_($_)
            ->setRPH($rPH)
            ->setId($id)
            ->setCoach($coach)
            ->setDetail($detail)
            ->setCode($code)
            ->setType($type);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\PassengerDetailsRQ\Structs\Placement
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\PassengerDetailsRQ\Structs\Placement
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\PassengerDetailsRQ\Structs\Placement
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Coach value
     * @return \Sabre\PassengerDetailsRQ\Structs\Coach[]|null
     */
    public function getCoach()
    {
        return $this->Coach;
    }
    /**
     * Set Coach value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\Coach[] $coach
     * @return \Sabre\PassengerDetailsRQ\Structs\Placement
     */
    public function setCoach(array $coach = array())
    {
        $this->Coach = $coach;
        return $this;
    }
    /**
     * Add item to Coach value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\Coach $item
     * @return \Sabre\PassengerDetailsRQ\Structs\Placement
     */
    public function addToCoach(\Sabre\PassengerDetailsRQ\Structs\Coach $item)
    {
        $this->Coach[] = $item;
        return $this;
    }
    /**
     * Get Detail value
     * @return string[]|null
     */
    public function getDetail()
    {
        return $this->Detail;
    }
    /**
     * Set Detail value
     * @throws \InvalidArgumentException
     * @param string[] $detail
     * @return \Sabre\PassengerDetailsRQ\Structs\Placement
     */
    public function setDetail(array $detail = array())
    {
        $this->Detail = $detail;
        return $this;
    }
    /**
     * Add item to Detail value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\PassengerDetailsRQ\Structs\Placement
     */
    public function addToDetail($item)
    {
        $this->Detail[] = $item;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \Sabre\PassengerDetailsRQ\Structs\Placement
     */
    public function setCode($code = null)
    {
        $this->code = $code;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \Sabre\PassengerDetailsRQ\Structs\Placement
     */
    public function setType($type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\Placement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
