<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentCard Structs
 * @subpackage Structs
 */
class PaymentCard extends AbstractStructBase
{
    /**
     * The ExpireDate
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: A type representing credit card expiration date. Accepted format: "yyyy-mm"
     * - pattern: \d{4}-\d{2}
     * @var int
     */
    public $ExpireDate;
    /**
     * The AirlineCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AirlineCode;
    /**
     * The CardSecurityCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CardSecurityCode;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - documentation: "Code" is used to return credit card code associated with the particular accounting line if applicable.
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The ExtendedPayment
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ExtendedPayment;
    /**
     * The ManualApprovalCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ManualApprovalCode;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - documentation: "Number" is used to return credit card number associated with the particular accounting line if applicable.
     * - use: optional
     * @var string
     */
    public $Number;
    /**
     * The SuppressApprovalCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $SuppressApprovalCode;
    /**
     * Constructor method for PaymentCard
     * @uses PaymentCard::setExpireDate()
     * @uses PaymentCard::setAirlineCode()
     * @uses PaymentCard::setCardSecurityCode()
     * @uses PaymentCard::setCode()
     * @uses PaymentCard::setExtendedPayment()
     * @uses PaymentCard::setManualApprovalCode()
     * @uses PaymentCard::setNumber()
     * @uses PaymentCard::setSuppressApprovalCode()
     * @param int $expireDate
     * @param string $airlineCode
     * @param string $cardSecurityCode
     * @param string $code
     * @param string $extendedPayment
     * @param string $manualApprovalCode
     * @param string $number
     * @param bool $suppressApprovalCode
     */
    public function __construct($expireDate = null, $airlineCode = null, $cardSecurityCode = null, $code = null, $extendedPayment = null, $manualApprovalCode = null, $number = null, $suppressApprovalCode = null)
    {
        $this
            ->setExpireDate($expireDate)
            ->setAirlineCode($airlineCode)
            ->setCardSecurityCode($cardSecurityCode)
            ->setCode($code)
            ->setExtendedPayment($extendedPayment)
            ->setManualApprovalCode($manualApprovalCode)
            ->setNumber($number)
            ->setSuppressApprovalCode($suppressApprovalCode);
    }
    /**
     * Get ExpireDate value
     * @return int
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param int $expireDate
     * @return \Sabre\PassengerDetailsRQ\Structs\PaymentCard
     */
    public function setExpireDate($expireDate = null)
    {
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get AirlineCode value
     * @return string|null
     */
    public function getAirlineCode()
    {
        return $this->AirlineCode;
    }
    /**
     * Set AirlineCode value
     * @param string $airlineCode
     * @return \Sabre\PassengerDetailsRQ\Structs\PaymentCard
     */
    public function setAirlineCode($airlineCode = null)
    {
        $this->AirlineCode = $airlineCode;
        return $this;
    }
    /**
     * Get CardSecurityCode value
     * @return string|null
     */
    public function getCardSecurityCode()
    {
        return $this->CardSecurityCode;
    }
    /**
     * Set CardSecurityCode value
     * @param string $cardSecurityCode
     * @return \Sabre\PassengerDetailsRQ\Structs\PaymentCard
     */
    public function setCardSecurityCode($cardSecurityCode = null)
    {
        $this->CardSecurityCode = $cardSecurityCode;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\PassengerDetailsRQ\Structs\PaymentCard
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get ExtendedPayment value
     * @return string|null
     */
    public function getExtendedPayment()
    {
        return $this->ExtendedPayment;
    }
    /**
     * Set ExtendedPayment value
     * @param string $extendedPayment
     * @return \Sabre\PassengerDetailsRQ\Structs\PaymentCard
     */
    public function setExtendedPayment($extendedPayment = null)
    {
        $this->ExtendedPayment = $extendedPayment;
        return $this;
    }
    /**
     * Get ManualApprovalCode value
     * @return string|null
     */
    public function getManualApprovalCode()
    {
        return $this->ManualApprovalCode;
    }
    /**
     * Set ManualApprovalCode value
     * @param string $manualApprovalCode
     * @return \Sabre\PassengerDetailsRQ\Structs\PaymentCard
     */
    public function setManualApprovalCode($manualApprovalCode = null)
    {
        $this->ManualApprovalCode = $manualApprovalCode;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \Sabre\PassengerDetailsRQ\Structs\PaymentCard
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get SuppressApprovalCode value
     * @return bool|null
     */
    public function getSuppressApprovalCode()
    {
        return $this->SuppressApprovalCode;
    }
    /**
     * Set SuppressApprovalCode value
     * @param bool $suppressApprovalCode
     * @return \Sabre\PassengerDetailsRQ\Structs\PaymentCard
     */
    public function setSuppressApprovalCode($suppressApprovalCode = null)
    {
        $this->SuppressApprovalCode = $suppressApprovalCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\PaymentCard
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
