<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerTypeQuantity Structs
 * @subpackage Structs
 */
class PassengerTypeQuantity extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - documentation: "Code" is used to return the passenger type code associated with the particular price quote.
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - documentation: "Quantity" is used to return the number of passengers associated with the particular passenger type code.
     * - use: optional
     * @var string
     */
    public $Quantity;
    /**
     * Constructor method for PassengerTypeQuantity
     * @uses PassengerTypeQuantity::setCode()
     * @uses PassengerTypeQuantity::setQuantity()
     * @param string $code
     * @param string $quantity
     */
    public function __construct($code = null, $quantity = null)
    {
        $this
            ->setCode($code)
            ->setQuantity($quantity);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\PassengerDetailsRQ\Structs\PassengerTypeQuantity
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param string $quantity
     * @return \Sabre\PassengerDetailsRQ\Structs\PassengerTypeQuantity
     */
    public function setQuantity($quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\PassengerTypeQuantity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
