<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartnerCarrier Structs
 * @subpackage Structs
 */
class PartnerCarrier extends AbstractStructBase
{
    /**
     * The Banner
     * Meta informations extracted from the WSDL
     * - documentation: "Banner" is used to return details of the operated airline related information.
     * - minOccurs: 0
     * @var string
     */
    public $Banner;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - documentation: "Code" is used to return the partner airline code associated with the particular flight segment.
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The FlightNumber
     * Meta informations extracted from the WSDL
     * - documentation: "FlightNumber" is used to return the flight number associated with the particular flight segment.
     * - use: optional
     * @var string
     */
    public $FlightNumber;
    /**
     * The ResBookDesigCode
     * Meta informations extracted from the WSDL
     * - documentation: "ResBookDesigCode" is used to return the reservation booking designator number associated with the particular flight segment.
     * - use: optional
     * @var string
     */
    public $ResBookDesigCode;
    /**
     * Constructor method for PartnerCarrier
     * @uses PartnerCarrier::setBanner()
     * @uses PartnerCarrier::setCode()
     * @uses PartnerCarrier::setFlightNumber()
     * @uses PartnerCarrier::setResBookDesigCode()
     * @param string $banner
     * @param string $code
     * @param string $flightNumber
     * @param string $resBookDesigCode
     */
    public function __construct($banner = null, $code = null, $flightNumber = null, $resBookDesigCode = null)
    {
        $this
            ->setBanner($banner)
            ->setCode($code)
            ->setFlightNumber($flightNumber)
            ->setResBookDesigCode($resBookDesigCode);
    }
    /**
     * Get Banner value
     * @return string|null
     */
    public function getBanner()
    {
        return $this->Banner;
    }
    /**
     * Set Banner value
     * @param string $banner
     * @return \Sabre\PassengerDetailsRQ\Structs\PartnerCarrier
     */
    public function setBanner($banner = null)
    {
        $this->Banner = $banner;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\PassengerDetailsRQ\Structs\PartnerCarrier
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \Sabre\PassengerDetailsRQ\Structs\PartnerCarrier
     */
    public function setFlightNumber($flightNumber = null)
    {
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get ResBookDesigCode value
     * @return string|null
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @param string $resBookDesigCode
     * @return \Sabre\PassengerDetailsRQ\Structs\PartnerCarrier
     */
    public function setResBookDesigCode($resBookDesigCode = null)
    {
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\PartnerCarrier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
