<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Mileage Structs
 * @subpackage Structs
 */
class Mileage extends AbstractStructBase
{
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - documentation: "CurrencyCode" is used to return the currency code associated with mileage charges.
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The ExtraMileageCharge
     * Meta informations extracted from the WSDL
     * - documentation: "ExtraMileageCharge" is used to return extra mileage charge-related information.
     * - use: optional
     * @var string
     */
    public $ExtraMileageCharge;
    /**
     * The UnitOfMeasure
     * Meta informations extracted from the WSDL
     * - documentation: "UnitOfMeasure" is used to return the unit of measurement, i.e. miles or kilometers.
     * - use: optional
     * @var string
     */
    public $UnitOfMeasure;
    /**
     * Constructor method for Mileage
     * @uses Mileage::setCurrencyCode()
     * @uses Mileage::setExtraMileageCharge()
     * @uses Mileage::setUnitOfMeasure()
     * @param string $currencyCode
     * @param string $extraMileageCharge
     * @param string $unitOfMeasure
     */
    public function __construct($currencyCode = null, $extraMileageCharge = null, $unitOfMeasure = null)
    {
        $this
            ->setCurrencyCode($currencyCode)
            ->setExtraMileageCharge($extraMileageCharge)
            ->setUnitOfMeasure($unitOfMeasure);
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\PassengerDetailsRQ\Structs\Mileage
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get ExtraMileageCharge value
     * @return string|null
     */
    public function getExtraMileageCharge()
    {
        return $this->ExtraMileageCharge;
    }
    /**
     * Set ExtraMileageCharge value
     * @param string $extraMileageCharge
     * @return \Sabre\PassengerDetailsRQ\Structs\Mileage
     */
    public function setExtraMileageCharge($extraMileageCharge = null)
    {
        $this->ExtraMileageCharge = $extraMileageCharge;
        return $this;
    }
    /**
     * Get UnitOfMeasure value
     * @return string|null
     */
    public function getUnitOfMeasure()
    {
        return $this->UnitOfMeasure;
    }
    /**
     * Set UnitOfMeasure value
     * @param string $unitOfMeasure
     * @return \Sabre\PassengerDetailsRQ\Structs\Mileage
     */
    public function setUnitOfMeasure($unitOfMeasure = null)
    {
        $this->UnitOfMeasure = $unitOfMeasure;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\Mileage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
