<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MarriageGrp Structs
 * @subpackage Structs
 */
class MarriageGrp extends AbstractStructBase
{
    /**
     * The Group
     * Meta informations extracted from the WSDL
     * - documentation: "Group" is used to return the marraige group number if applicable.
     * - use: optional
     * @var string
     */
    public $Group;
    /**
     * The Ind
     * Meta informations extracted from the WSDL
     * - documentation: "Ind" is used to indicate that the particular flight segment is part of a married connection.
     * - use: optional
     * @var string
     */
    public $Ind;
    /**
     * The Sequence
     * Meta informations extracted from the WSDL
     * - documentation: "Sequence" is used to return the marraige sequence number if applicable.
     * - use: optional
     * @var string
     */
    public $Sequence;
    /**
     * Constructor method for MarriageGrp
     * @uses MarriageGrp::setGroup()
     * @uses MarriageGrp::setInd()
     * @uses MarriageGrp::setSequence()
     * @param string $group
     * @param string $ind
     * @param string $sequence
     */
    public function __construct($group = null, $ind = null, $sequence = null)
    {
        $this
            ->setGroup($group)
            ->setInd($ind)
            ->setSequence($sequence);
    }
    /**
     * Get Group value
     * @return string|null
     */
    public function getGroup()
    {
        return $this->Group;
    }
    /**
     * Set Group value
     * @param string $group
     * @return \Sabre\PassengerDetailsRQ\Structs\MarriageGrp
     */
    public function setGroup($group = null)
    {
        $this->Group = $group;
        return $this;
    }
    /**
     * Get Ind value
     * @return string|null
     */
    public function getInd()
    {
        return $this->Ind;
    }
    /**
     * Set Ind value
     * @param string $ind
     * @return \Sabre\PassengerDetailsRQ\Structs\MarriageGrp
     */
    public function setInd($ind = null)
    {
        $this->Ind = $ind;
        return $this;
    }
    /**
     * Get Sequence value
     * @return string|null
     */
    public function getSequence()
    {
        return $this->Sequence;
    }
    /**
     * Set Sequence value
     * @param string $sequence
     * @return \Sabre\PassengerDetailsRQ\Structs\MarriageGrp
     */
    public function setSequence($sequence = null)
    {
        $this->Sequence = $sequence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\MarriageGrp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
