<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Link Structs
 * @subpackage Structs
 */
class Link extends AbstractStructBase
{
    /**
     * The Record
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Record;
    /**
     * The HostedCarrier
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $HostedCarrier;
    /**
     * The NameNumber
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $NameNumber;
    /**
     * Constructor method for Link
     * @uses Link::setRecord()
     * @uses Link::setHostedCarrier()
     * @uses Link::setNameNumber()
     * @param string $record
     * @param bool $hostedCarrier
     * @param string $nameNumber
     */
    public function __construct($record = null, $hostedCarrier = null, $nameNumber = null)
    {
        $this
            ->setRecord($record)
            ->setHostedCarrier($hostedCarrier)
            ->setNameNumber($nameNumber);
    }
    /**
     * Get Record value
     * @return string
     */
    public function getRecord()
    {
        return $this->Record;
    }
    /**
     * Set Record value
     * @param string $record
     * @return \Sabre\PassengerDetailsRQ\Structs\Link
     */
    public function setRecord($record = null)
    {
        $this->Record = $record;
        return $this;
    }
    /**
     * Get HostedCarrier value
     * @return bool|null
     */
    public function getHostedCarrier()
    {
        return $this->HostedCarrier;
    }
    /**
     * Set HostedCarrier value
     * @param bool $hostedCarrier
     * @return \Sabre\PassengerDetailsRQ\Structs\Link
     */
    public function setHostedCarrier($hostedCarrier = null)
    {
        $this->HostedCarrier = $hostedCarrier;
        return $this;
    }
    /**
     * Get NameNumber value
     * @return string|null
     */
    public function getNameNumber()
    {
        return $this->NameNumber;
    }
    /**
     * Set NameNumber value
     * @param string $nameNumber
     * @return \Sabre\PassengerDetailsRQ\Structs\Link
     */
    public function setNameNumber($nameNumber = null)
    {
        $this->NameNumber = $nameNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\Link
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
