<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItineraryPricing Structs
 * @subpackage Structs
 */
class ItineraryPricing extends AbstractStructBase
{
    /**
     * The FuturePriceInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\FuturePriceInfo[]
     */
    public $FuturePriceInfo;
    /**
     * The PriceQuote
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\PriceQuote[]
     */
    public $PriceQuote;
    /**
     * The PriceQuoteTotals
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\PriceQuoteTotals
     */
    public $PriceQuoteTotals;
    /**
     * Constructor method for ItineraryPricing
     * @uses ItineraryPricing::setFuturePriceInfo()
     * @uses ItineraryPricing::setPriceQuote()
     * @uses ItineraryPricing::setPriceQuoteTotals()
     * @param \Sabre\PassengerDetailsRQ\Structs\FuturePriceInfo[] $futurePriceInfo
     * @param \Sabre\PassengerDetailsRQ\Structs\PriceQuote[] $priceQuote
     * @param \Sabre\PassengerDetailsRQ\Structs\PriceQuoteTotals $priceQuoteTotals
     */
    public function __construct(array $futurePriceInfo = array(), array $priceQuote = array(), \Sabre\PassengerDetailsRQ\Structs\PriceQuoteTotals $priceQuoteTotals = null)
    {
        $this
            ->setFuturePriceInfo($futurePriceInfo)
            ->setPriceQuote($priceQuote)
            ->setPriceQuoteTotals($priceQuoteTotals);
    }
    /**
     * Get FuturePriceInfo value
     * @return \Sabre\PassengerDetailsRQ\Structs\FuturePriceInfo[]|null
     */
    public function getFuturePriceInfo()
    {
        return $this->FuturePriceInfo;
    }
    /**
     * Set FuturePriceInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\FuturePriceInfo[] $futurePriceInfo
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryPricing
     */
    public function setFuturePriceInfo(array $futurePriceInfo = array())
    {
        $this->FuturePriceInfo = $futurePriceInfo;
        return $this;
    }
    /**
     * Add item to FuturePriceInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\FuturePriceInfo $item
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryPricing
     */
    public function addToFuturePriceInfo(\Sabre\PassengerDetailsRQ\Structs\FuturePriceInfo $item)
    {
        $this->FuturePriceInfo[] = $item;
        return $this;
    }
    /**
     * Get PriceQuote value
     * @return \Sabre\PassengerDetailsRQ\Structs\PriceQuote[]|null
     */
    public function getPriceQuote()
    {
        return $this->PriceQuote;
    }
    /**
     * Set PriceQuote value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\PriceQuote[] $priceQuote
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryPricing
     */
    public function setPriceQuote(array $priceQuote = array())
    {
        $this->PriceQuote = $priceQuote;
        return $this;
    }
    /**
     * Add item to PriceQuote value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\PriceQuote $item
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryPricing
     */
    public function addToPriceQuote(\Sabre\PassengerDetailsRQ\Structs\PriceQuote $item)
    {
        $this->PriceQuote[] = $item;
        return $this;
    }
    /**
     * Get PriceQuoteTotals value
     * @return \Sabre\PassengerDetailsRQ\Structs\PriceQuoteTotals|null
     */
    public function getPriceQuoteTotals()
    {
        return $this->PriceQuoteTotals;
    }
    /**
     * Set PriceQuoteTotals value
     * @param \Sabre\PassengerDetailsRQ\Structs\PriceQuoteTotals $priceQuoteTotals
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryPricing
     */
    public function setPriceQuoteTotals(\Sabre\PassengerDetailsRQ\Structs\PriceQuoteTotals $priceQuoteTotals = null)
    {
        $this->PriceQuoteTotals = $priceQuoteTotals;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryPricing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
