<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItineraryInfo Structs
 * @subpackage Structs
 */
class ItineraryInfo extends AbstractStructBase
{
    /**
     * The ItineraryPricing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\ItineraryPricing
     */
    public $ItineraryPricing;
    /**
     * The ReservationItems
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\ReservationItems
     */
    public $ReservationItems;
    /**
     * The Ticketing
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Ticketing[]
     */
    public $Ticketing;
    /**
     * Constructor method for ItineraryInfo
     * @uses ItineraryInfo::setItineraryPricing()
     * @uses ItineraryInfo::setReservationItems()
     * @uses ItineraryInfo::setTicketing()
     * @param \Sabre\PassengerDetailsRQ\Structs\ItineraryPricing $itineraryPricing
     * @param \Sabre\PassengerDetailsRQ\Structs\ReservationItems $reservationItems
     * @param \Sabre\PassengerDetailsRQ\Structs\Ticketing[] $ticketing
     */
    public function __construct(\Sabre\PassengerDetailsRQ\Structs\ItineraryPricing $itineraryPricing = null, \Sabre\PassengerDetailsRQ\Structs\ReservationItems $reservationItems = null, array $ticketing = array())
    {
        $this
            ->setItineraryPricing($itineraryPricing)
            ->setReservationItems($reservationItems)
            ->setTicketing($ticketing);
    }
    /**
     * Get ItineraryPricing value
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryPricing|null
     */
    public function getItineraryPricing()
    {
        return $this->ItineraryPricing;
    }
    /**
     * Set ItineraryPricing value
     * @param \Sabre\PassengerDetailsRQ\Structs\ItineraryPricing $itineraryPricing
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryInfo
     */
    public function setItineraryPricing(\Sabre\PassengerDetailsRQ\Structs\ItineraryPricing $itineraryPricing = null)
    {
        $this->ItineraryPricing = $itineraryPricing;
        return $this;
    }
    /**
     * Get ReservationItems value
     * @return \Sabre\PassengerDetailsRQ\Structs\ReservationItems|null
     */
    public function getReservationItems()
    {
        return $this->ReservationItems;
    }
    /**
     * Set ReservationItems value
     * @param \Sabre\PassengerDetailsRQ\Structs\ReservationItems $reservationItems
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryInfo
     */
    public function setReservationItems(\Sabre\PassengerDetailsRQ\Structs\ReservationItems $reservationItems = null)
    {
        $this->ReservationItems = $reservationItems;
        return $this;
    }
    /**
     * Get Ticketing value
     * @return \Sabre\PassengerDetailsRQ\Structs\Ticketing[]|null
     */
    public function getTicketing()
    {
        return $this->Ticketing;
    }
    /**
     * Set Ticketing value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\Ticketing[] $ticketing
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryInfo
     */
    public function setTicketing(array $ticketing = array())
    {
        $this->Ticketing = $ticketing;
        return $this;
    }
    /**
     * Add item to Ticketing value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\Ticketing $item
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryInfo
     */
    public function addToTicketing(\Sabre\PassengerDetailsRQ\Structs\Ticketing $item)
    {
        $this->Ticketing[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\ItineraryInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
