<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupInfo Structs
 * @subpackage Structs
 */
class GroupInfo extends AbstractStructBase
{
    /**
     * The VendorPrefs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\VendorPrefs
     */
    public $VendorPrefs;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - documentation: "Name" is used to return the corporate/group name.
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * The NumSeatsRemaining
     * Meta informations extracted from the WSDL
     * - documentation: "NumSeatsRemaining" is used to return the number of remaining seats.
     * - use: optional
     * @var int
     */
    public $NumSeatsRemaining;
    /**
     * The AssociatedReferenceInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\AssociatedReferenceInformation
     */
    public $AssociatedReferenceInformation;
    /**
     * The OriginalNumberOfSeats
     * Meta informations extracted from the WSDL
     * - documentation: "OriginalNumberOfSeats" is used to return the original number of seats requested in the BSG
     * - use: optional
     * @var string
     */
    public $OriginalNumberOfSeats;
    /**
     * The GroupNameNumber
     * Meta informations extracted from the WSDL
     * - documentation: "GroupNameNumber" is used to return the passenger name number in relation to the rest of the group.
     * - use: optional
     * @var string
     */
    public $GroupNameNumber;
    /**
     * The SoldNumberOfSeats
     * Meta informations extracted from the WSDL
     * - documentation: "SoldNumberOfSeats is used to return the number of seats sold from the BSG"
     * - use: optional
     * @var string
     */
    public $SoldNumberOfSeats;
    /**
     * Constructor method for GroupInfo
     * @uses GroupInfo::setVendorPrefs()
     * @uses GroupInfo::setName()
     * @uses GroupInfo::setNumSeatsRemaining()
     * @uses GroupInfo::setAssociatedReferenceInformation()
     * @uses GroupInfo::setOriginalNumberOfSeats()
     * @uses GroupInfo::setGroupNameNumber()
     * @uses GroupInfo::setSoldNumberOfSeats()
     * @param \Sabre\PassengerDetailsRQ\Structs\VendorPrefs $vendorPrefs
     * @param string $name
     * @param int $numSeatsRemaining
     * @param \Sabre\PassengerDetailsRQ\Structs\AssociatedReferenceInformation $associatedReferenceInformation
     * @param string $originalNumberOfSeats
     * @param string $groupNameNumber
     * @param string $soldNumberOfSeats
     */
    public function __construct(\Sabre\PassengerDetailsRQ\Structs\VendorPrefs $vendorPrefs = null, $name = null, $numSeatsRemaining = null, \Sabre\PassengerDetailsRQ\Structs\AssociatedReferenceInformation $associatedReferenceInformation = null, $originalNumberOfSeats = null, $groupNameNumber = null, $soldNumberOfSeats = null)
    {
        $this
            ->setVendorPrefs($vendorPrefs)
            ->setName($name)
            ->setNumSeatsRemaining($numSeatsRemaining)
            ->setAssociatedReferenceInformation($associatedReferenceInformation)
            ->setOriginalNumberOfSeats($originalNumberOfSeats)
            ->setGroupNameNumber($groupNameNumber)
            ->setSoldNumberOfSeats($soldNumberOfSeats);
    }
    /**
     * Get VendorPrefs value
     * @return \Sabre\PassengerDetailsRQ\Structs\VendorPrefs|null
     */
    public function getVendorPrefs()
    {
        return $this->VendorPrefs;
    }
    /**
     * Set VendorPrefs value
     * @param \Sabre\PassengerDetailsRQ\Structs\VendorPrefs $vendorPrefs
     * @return \Sabre\PassengerDetailsRQ\Structs\GroupInfo
     */
    public function setVendorPrefs(\Sabre\PassengerDetailsRQ\Structs\VendorPrefs $vendorPrefs = null)
    {
        $this->VendorPrefs = $vendorPrefs;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Sabre\PassengerDetailsRQ\Structs\GroupInfo
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get NumSeatsRemaining value
     * @return int|null
     */
    public function getNumSeatsRemaining()
    {
        return $this->NumSeatsRemaining;
    }
    /**
     * Set NumSeatsRemaining value
     * @param int $numSeatsRemaining
     * @return \Sabre\PassengerDetailsRQ\Structs\GroupInfo
     */
    public function setNumSeatsRemaining($numSeatsRemaining = null)
    {
        $this->NumSeatsRemaining = $numSeatsRemaining;
        return $this;
    }
    /**
     * Get AssociatedReferenceInformation value
     * @return \Sabre\PassengerDetailsRQ\Structs\AssociatedReferenceInformation|null
     */
    public function getAssociatedReferenceInformation()
    {
        return $this->AssociatedReferenceInformation;
    }
    /**
     * Set AssociatedReferenceInformation value
     * @param \Sabre\PassengerDetailsRQ\Structs\AssociatedReferenceInformation $associatedReferenceInformation
     * @return \Sabre\PassengerDetailsRQ\Structs\GroupInfo
     */
    public function setAssociatedReferenceInformation(\Sabre\PassengerDetailsRQ\Structs\AssociatedReferenceInformation $associatedReferenceInformation = null)
    {
        $this->AssociatedReferenceInformation = $associatedReferenceInformation;
        return $this;
    }
    /**
     * Get OriginalNumberOfSeats value
     * @return string|null
     */
    public function getOriginalNumberOfSeats()
    {
        return $this->OriginalNumberOfSeats;
    }
    /**
     * Set OriginalNumberOfSeats value
     * @param string $originalNumberOfSeats
     * @return \Sabre\PassengerDetailsRQ\Structs\GroupInfo
     */
    public function setOriginalNumberOfSeats($originalNumberOfSeats = null)
    {
        $this->OriginalNumberOfSeats = $originalNumberOfSeats;
        return $this;
    }
    /**
     * Get GroupNameNumber value
     * @return string|null
     */
    public function getGroupNameNumber()
    {
        return $this->GroupNameNumber;
    }
    /**
     * Set GroupNameNumber value
     * @param string $groupNameNumber
     * @return \Sabre\PassengerDetailsRQ\Structs\GroupInfo
     */
    public function setGroupNameNumber($groupNameNumber = null)
    {
        $this->GroupNameNumber = $groupNameNumber;
        return $this;
    }
    /**
     * Get SoldNumberOfSeats value
     * @return string|null
     */
    public function getSoldNumberOfSeats()
    {
        return $this->SoldNumberOfSeats;
    }
    /**
     * Set SoldNumberOfSeats value
     * @param string $soldNumberOfSeats
     * @return \Sabre\PassengerDetailsRQ\Structs\GroupInfo
     */
    public function setSoldNumberOfSeats($soldNumberOfSeats = null)
    {
        $this->SoldNumberOfSeats = $soldNumberOfSeats;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\GroupInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
