<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeeInformation Structs
 * @subpackage Structs
 */
class FeeInformation extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The AccountData
     * Meta informations extracted from the WSDL
     * - documentation: "AccountData" is used to return ticketing fee account-related information.
     * - use: optional
     * @var string
     */
    public $AccountData;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: "Amount" is used to return the ticketing fee amount.
     * - use: optional
     * @var string
     */
    public $Amount;
    /**
     * The DisplayOnOutputInd
     * Meta informations extracted from the WSDL
     * - documentation: "DisplayOnOutputInd" is used to is used to indicate whether or not the fee is displayed on output.
     * - use: optional
     * @var string
     */
    public $DisplayOnOutputInd;
    /**
     * The FunctionCode
     * Meta informations extracted from the WSDL
     * - documentation: "FunctionCode" is used to return the ticketing fee function code.
     * - use: optional
     * @var string
     */
    public $FunctionCode;
    /**
     * The GuaranteeType
     * Meta informations extracted from the WSDL
     * - documentation: "GuaranteeType" is used to return the ticketing fee guarantee type.
     * - use: optional
     * @var string
     */
    public $GuaranteeType;
    /**
     * The NonCommissionInd
     * Meta informations extracted from the WSDL
     * - documentation: "NonCommissionInd" is used to is used to indicate whether or not the fee is commission eligible.
     * - use: optional
     * @var string
     */
    public $NonCommissionInd;
    /**
     * The NonRefundableInd
     * Meta informations extracted from the WSDL
     * - documentation: "NonRefundableInd" is used to is used to indicate whether or not the fee is refundable.
     * - use: optional
     * @var string
     */
    public $NonRefundableInd;
    /**
     * The OnlineInterlineService
     * Meta informations extracted from the WSDL
     * - documentation: "OnlineInterlineService" is used to is used to return online/interline-related information.
     * - use: optional
     * @var string
     */
    public $OnlineInterlineService;
    /**
     * The ServiceType
     * Meta informations extracted from the WSDL
     * - documentation: "ServiceType" is used to return the ticketing fee service type.
     * - use: optional
     * @var string
     */
    public $ServiceType;
    /**
     * The CurrenyCode
     * Meta informations extracted from the WSDL
     * - documentation: Ob Fee Currency Code.
     * - use: optional
     * @var string
     */
    public $CurrenyCode;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: Ob Fee Description.
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The WaiverCode
     * Meta informations extracted from the WSDL
     * - documentation: "WaiverCode" is used to return the Waiver code.
     * - use: optional
     * @var string
     */
    public $WaiverCode;
    /**
     * Constructor method for FeeInformation
     * @uses FeeInformation::set_()
     * @uses FeeInformation::setAccountData()
     * @uses FeeInformation::setAmount()
     * @uses FeeInformation::setDisplayOnOutputInd()
     * @uses FeeInformation::setFunctionCode()
     * @uses FeeInformation::setGuaranteeType()
     * @uses FeeInformation::setNonCommissionInd()
     * @uses FeeInformation::setNonRefundableInd()
     * @uses FeeInformation::setOnlineInterlineService()
     * @uses FeeInformation::setServiceType()
     * @uses FeeInformation::setCurrenyCode()
     * @uses FeeInformation::setDescription()
     * @uses FeeInformation::setWaiverCode()
     * @param string $_
     * @param string $accountData
     * @param string $amount
     * @param string $displayOnOutputInd
     * @param string $functionCode
     * @param string $guaranteeType
     * @param string $nonCommissionInd
     * @param string $nonRefundableInd
     * @param string $onlineInterlineService
     * @param string $serviceType
     * @param string $currenyCode
     * @param string $description
     * @param string $waiverCode
     */
    public function __construct($_ = null, $accountData = null, $amount = null, $displayOnOutputInd = null, $functionCode = null, $guaranteeType = null, $nonCommissionInd = null, $nonRefundableInd = null, $onlineInterlineService = null, $serviceType = null, $currenyCode = null, $description = null, $waiverCode = null)
    {
        $this
            ->set_($_)
            ->setAccountData($accountData)
            ->setAmount($amount)
            ->setDisplayOnOutputInd($displayOnOutputInd)
            ->setFunctionCode($functionCode)
            ->setGuaranteeType($guaranteeType)
            ->setNonCommissionInd($nonCommissionInd)
            ->setNonRefundableInd($nonRefundableInd)
            ->setOnlineInterlineService($onlineInterlineService)
            ->setServiceType($serviceType)
            ->setCurrenyCode($currenyCode)
            ->setDescription($description)
            ->setWaiverCode($waiverCode);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\PassengerDetailsRQ\Structs\FeeInformation
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get AccountData value
     * @return string|null
     */
    public function getAccountData()
    {
        return $this->AccountData;
    }
    /**
     * Set AccountData value
     * @param string $accountData
     * @return \Sabre\PassengerDetailsRQ\Structs\FeeInformation
     */
    public function setAccountData($accountData = null)
    {
        $this->AccountData = $accountData;
        return $this;
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\PassengerDetailsRQ\Structs\FeeInformation
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get DisplayOnOutputInd value
     * @return string|null
     */
    public function getDisplayOnOutputInd()
    {
        return $this->DisplayOnOutputInd;
    }
    /**
     * Set DisplayOnOutputInd value
     * @param string $displayOnOutputInd
     * @return \Sabre\PassengerDetailsRQ\Structs\FeeInformation
     */
    public function setDisplayOnOutputInd($displayOnOutputInd = null)
    {
        $this->DisplayOnOutputInd = $displayOnOutputInd;
        return $this;
    }
    /**
     * Get FunctionCode value
     * @return string|null
     */
    public function getFunctionCode()
    {
        return $this->FunctionCode;
    }
    /**
     * Set FunctionCode value
     * @param string $functionCode
     * @return \Sabre\PassengerDetailsRQ\Structs\FeeInformation
     */
    public function setFunctionCode($functionCode = null)
    {
        $this->FunctionCode = $functionCode;
        return $this;
    }
    /**
     * Get GuaranteeType value
     * @return string|null
     */
    public function getGuaranteeType()
    {
        return $this->GuaranteeType;
    }
    /**
     * Set GuaranteeType value
     * @param string $guaranteeType
     * @return \Sabre\PassengerDetailsRQ\Structs\FeeInformation
     */
    public function setGuaranteeType($guaranteeType = null)
    {
        $this->GuaranteeType = $guaranteeType;
        return $this;
    }
    /**
     * Get NonCommissionInd value
     * @return string|null
     */
    public function getNonCommissionInd()
    {
        return $this->NonCommissionInd;
    }
    /**
     * Set NonCommissionInd value
     * @param string $nonCommissionInd
     * @return \Sabre\PassengerDetailsRQ\Structs\FeeInformation
     */
    public function setNonCommissionInd($nonCommissionInd = null)
    {
        $this->NonCommissionInd = $nonCommissionInd;
        return $this;
    }
    /**
     * Get NonRefundableInd value
     * @return string|null
     */
    public function getNonRefundableInd()
    {
        return $this->NonRefundableInd;
    }
    /**
     * Set NonRefundableInd value
     * @param string $nonRefundableInd
     * @return \Sabre\PassengerDetailsRQ\Structs\FeeInformation
     */
    public function setNonRefundableInd($nonRefundableInd = null)
    {
        $this->NonRefundableInd = $nonRefundableInd;
        return $this;
    }
    /**
     * Get OnlineInterlineService value
     * @return string|null
     */
    public function getOnlineInterlineService()
    {
        return $this->OnlineInterlineService;
    }
    /**
     * Set OnlineInterlineService value
     * @param string $onlineInterlineService
     * @return \Sabre\PassengerDetailsRQ\Structs\FeeInformation
     */
    public function setOnlineInterlineService($onlineInterlineService = null)
    {
        $this->OnlineInterlineService = $onlineInterlineService;
        return $this;
    }
    /**
     * Get ServiceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->ServiceType;
    }
    /**
     * Set ServiceType value
     * @param string $serviceType
     * @return \Sabre\PassengerDetailsRQ\Structs\FeeInformation
     */
    public function setServiceType($serviceType = null)
    {
        $this->ServiceType = $serviceType;
        return $this;
    }
    /**
     * Get CurrenyCode value
     * @return string|null
     */
    public function getCurrenyCode()
    {
        return $this->CurrenyCode;
    }
    /**
     * Set CurrenyCode value
     * @param string $currenyCode
     * @return \Sabre\PassengerDetailsRQ\Structs\FeeInformation
     */
    public function setCurrenyCode($currenyCode = null)
    {
        $this->CurrenyCode = $currenyCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Sabre\PassengerDetailsRQ\Structs\FeeInformation
     */
    public function setDescription($description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get WaiverCode value
     * @return string|null
     */
    public function getWaiverCode()
    {
        return $this->WaiverCode;
    }
    /**
     * Set WaiverCode value
     * @param string $waiverCode
     * @return \Sabre\PassengerDetailsRQ\Structs\FeeInformation
     */
    public function setWaiverCode($waiverCode = null)
    {
        $this->WaiverCode = $waiverCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\FeeInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
