<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Error Structs
 * @subpackage Structs
 */
class Error extends AbstractStructBase
{
    /**
     * The errorCode
     * Meta informations extracted from the WSDL
     * - use: required
     * - minLength: 1
     * @var string
     */
    public $errorCode;
    /**
     * The severity
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $severity;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:Description
     * @var \Sabre\PassengerDetailsRQ\Structs\Description
     */
    public $Description;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - ref: tns:id
     * @var \Sabre\PassengerDetailsRQ\Structs\ID
     */
    public $id;
    /**
     * The codeContext
     * Meta informations extracted from the WSDL
     * - default: urn:oasis:names:tc:ebxml-msg:service:errors
     * @var string
     */
    public $codeContext;
    /**
     * The location
     * Meta informations extracted from the WSDL
     * - minLength: 1
     * @var string
     */
    public $location;
    /**
     * Constructor method for Error
     * @uses Error::setErrorCode()
     * @uses Error::setSeverity()
     * @uses Error::setDescription()
     * @uses Error::setAny()
     * @uses Error::setId()
     * @uses Error::setCodeContext()
     * @uses Error::setLocation()
     * @param string $errorCode
     * @param string $severity
     * @param \Sabre\PassengerDetailsRQ\Structs\Description $description
     * @param \DOMDocument $any
     * @param \Sabre\PassengerDetailsRQ\Structs\ID $id
     * @param string $codeContext
     * @param string $location
     */
    public function __construct($errorCode = null, $severity = null, \Sabre\PassengerDetailsRQ\Structs\Description $description = null, \DOMDocument $any = null, \Sabre\PassengerDetailsRQ\Structs\ID $id = null, $codeContext = 'urn:oasis:names:tc:ebxml-msg:service:errors', $location = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setSeverity($severity)
            ->setDescription($description)
            ->setAny($any)
            ->setId($id)
            ->setCodeContext($codeContext)
            ->setLocation($location);
    }
    /**
     * Get errorCode value
     * @return string
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @param string $errorCode
     * @return \Sabre\PassengerDetailsRQ\Structs\Error
     */
    public function setErrorCode($errorCode = null)
    {
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get severity value
     * @return string
     */
    public function getSeverity()
    {
        return $this->severity;
    }
    /**
     * Set severity value
     * @uses \Sabre\PassengerDetailsRQ\Enums\Severity_type::valueIsValid()
     * @uses \Sabre\PassengerDetailsRQ\Enums\Severity_type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $severity
     * @return \Sabre\PassengerDetailsRQ\Structs\Error
     */
    public function setSeverity($severity = null)
    {
        $this->severity = $severity;
        return $this;
    }
    /**
     * Get Description value
     * @return \Sabre\PassengerDetailsRQ\Structs\Description|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \Sabre\PassengerDetailsRQ\Structs\Description $description
     * @return \Sabre\PassengerDetailsRQ\Structs\Error
     */
    public function setDescription(\Sabre\PassengerDetailsRQ\Structs\Description $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Sabre\PassengerDetailsRQ\Structs\Error::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Sabre\PassengerDetailsRQ\Structs\Error
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Get id value
     * @return \Sabre\PassengerDetailsRQ\Structs\ID|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \Sabre\PassengerDetailsRQ\Structs\ID $id
     * @return \Sabre\PassengerDetailsRQ\Structs\Error
     */
    public function setId(\Sabre\PassengerDetailsRQ\Structs\ID $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get codeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->codeContext;
    }
    /**
     * Set codeContext value
     * @param string $codeContext
     * @return \Sabre\PassengerDetailsRQ\Structs\Error
     */
    public function setCodeContext($codeContext = 'urn:oasis:names:tc:ebxml-msg:service:errors')
    {
        $this->codeContext = $codeContext;
        return $this;
    }
    /**
     * Get location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param string $location
     * @return \Sabre\PassengerDetailsRQ\Structs\Error
     */
    public function setLocation($location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\Error
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
