<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eTicket Structs
 * Meta informations extracted from the WSDL
 * - documentation: "eTicket" holds indicator to denote whether or not the flight segment associated with the accounting line is eticket eligible Example: eTicket Ind="false"
 * @subpackage Structs
 */
class ETicket extends AbstractStructBase
{
    /**
     * The PDF
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\PDF
     */
    public $PDF;
    /**
     * The Ind
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $Ind;
    /**
     * Constructor method for eTicket
     * @uses ETicket::setPDF()
     * @uses ETicket::setInd()
     * @param \Sabre\PassengerDetailsRQ\Structs\PDF $pDF
     * @param bool $ind
     */
    public function __construct(\Sabre\PassengerDetailsRQ\Structs\PDF $pDF = null, $ind = null)
    {
        $this
            ->setPDF($pDF)
            ->setInd($ind);
    }
    /**
     * Get PDF value
     * @return \Sabre\PassengerDetailsRQ\Structs\PDF|null
     */
    public function getPDF()
    {
        return $this->PDF;
    }
    /**
     * Set PDF value
     * @param \Sabre\PassengerDetailsRQ\Structs\PDF $pDF
     * @return \Sabre\PassengerDetailsRQ\Structs\ETicket
     */
    public function setPDF(\Sabre\PassengerDetailsRQ\Structs\PDF $pDF = null)
    {
        $this->PDF = $pDF;
        return $this;
    }
    /**
     * Get Ind value
     * @return bool|null
     */
    public function getInd()
    {
        return $this->Ind;
    }
    /**
     * Set Ind value
     * @param bool $ind
     * @return \Sabre\PassengerDetailsRQ\Structs\ETicket
     */
    public function setInd($ind = null)
    {
        $this->Ind = $ind;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\ETicket
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
