<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentRules Structs
 * @subpackage Structs
 */
class DocumentRules extends AbstractStructBase
{
    /**
     * The Exchangable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Exchangable;
    /**
     * The Refundable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Refundable;
    /**
     * The Rule
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Rule[]
     */
    public $Rule;
    /**
     * Constructor method for DocumentRules
     * @uses DocumentRules::setExchangable()
     * @uses DocumentRules::setRefundable()
     * @uses DocumentRules::setRule()
     * @param string $exchangable
     * @param string $refundable
     * @param \Sabre\PassengerDetailsRQ\Structs\Rule[] $rule
     */
    public function __construct($exchangable = null, $refundable = null, array $rule = array())
    {
        $this
            ->setExchangable($exchangable)
            ->setRefundable($refundable)
            ->setRule($rule);
    }
    /**
     * Get Exchangable value
     * @return string|null
     */
    public function getExchangable()
    {
        return $this->Exchangable;
    }
    /**
     * Set Exchangable value
     * @param string $exchangable
     * @return \Sabre\PassengerDetailsRQ\Structs\DocumentRules
     */
    public function setExchangable($exchangable = null)
    {
        $this->Exchangable = $exchangable;
        return $this;
    }
    /**
     * Get Refundable value
     * @return string|null
     */
    public function getRefundable()
    {
        return $this->Refundable;
    }
    /**
     * Set Refundable value
     * @param string $refundable
     * @return \Sabre\PassengerDetailsRQ\Structs\DocumentRules
     */
    public function setRefundable($refundable = null)
    {
        $this->Refundable = $refundable;
        return $this;
    }
    /**
     * Get Rule value
     * @return \Sabre\PassengerDetailsRQ\Structs\Rule[]|null
     */
    public function getRule()
    {
        return $this->Rule;
    }
    /**
     * Set Rule value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\Rule[] $rule
     * @return \Sabre\PassengerDetailsRQ\Structs\DocumentRules
     */
    public function setRule(array $rule = array())
    {
        $this->Rule = $rule;
        return $this;
    }
    /**
     * Add item to Rule value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\Rule $item
     * @return \Sabre\PassengerDetailsRQ\Structs\DocumentRules
     */
    public function addToRule(\Sabre\PassengerDetailsRQ\Structs\Rule $item)
    {
        $this->Rule[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\DocumentRules
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
