<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Customer Structs
 * @subpackage Structs
 */
class Customer extends AbstractStructBase
{
    /**
     * The Corporate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Corporate
     */
    public $Corporate;
    /**
     * The CustLoyalty
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\CustLoyalty[]
     */
    public $CustLoyalty;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\ID
     */
    public $ID;
    /**
     * The ReserveUnderName
     * Meta informations extracted from the WSDL
     * - documentation: "ReserveUnderName" is used to return name/reservation-related information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ReserveUnderName;
    /**
     * Constructor method for Customer
     * @uses Customer::setCorporate()
     * @uses Customer::setCustLoyalty()
     * @uses Customer::setID()
     * @uses Customer::setReserveUnderName()
     * @param \Sabre\PassengerDetailsRQ\Structs\Corporate $corporate
     * @param \Sabre\PassengerDetailsRQ\Structs\CustLoyalty[] $custLoyalty
     * @param \Sabre\PassengerDetailsRQ\Structs\ID $iD
     * @param string[] $reserveUnderName
     */
    public function __construct(\Sabre\PassengerDetailsRQ\Structs\Corporate $corporate = null, array $custLoyalty = array(), \Sabre\PassengerDetailsRQ\Structs\ID $iD = null, array $reserveUnderName = array())
    {
        $this
            ->setCorporate($corporate)
            ->setCustLoyalty($custLoyalty)
            ->setID($iD)
            ->setReserveUnderName($reserveUnderName);
    }
    /**
     * Get Corporate value
     * @return \Sabre\PassengerDetailsRQ\Structs\Corporate|null
     */
    public function getCorporate()
    {
        return $this->Corporate;
    }
    /**
     * Set Corporate value
     * @param \Sabre\PassengerDetailsRQ\Structs\Corporate $corporate
     * @return \Sabre\PassengerDetailsRQ\Structs\Customer
     */
    public function setCorporate(\Sabre\PassengerDetailsRQ\Structs\Corporate $corporate = null)
    {
        $this->Corporate = $corporate;
        return $this;
    }
    /**
     * Get CustLoyalty value
     * @return \Sabre\PassengerDetailsRQ\Structs\CustLoyalty[]|null
     */
    public function getCustLoyalty()
    {
        return $this->CustLoyalty;
    }
    /**
     * Set CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\CustLoyalty[] $custLoyalty
     * @return \Sabre\PassengerDetailsRQ\Structs\Customer
     */
    public function setCustLoyalty(array $custLoyalty = array())
    {
        $this->CustLoyalty = $custLoyalty;
        return $this;
    }
    /**
     * Add item to CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\CustLoyalty $item
     * @return \Sabre\PassengerDetailsRQ\Structs\Customer
     */
    public function addToCustLoyalty(\Sabre\PassengerDetailsRQ\Structs\CustLoyalty $item)
    {
        $this->CustLoyalty[] = $item;
        return $this;
    }
    /**
     * Get ID value
     * @return \Sabre\PassengerDetailsRQ\Structs\ID|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Sabre\PassengerDetailsRQ\Structs\ID $iD
     * @return \Sabre\PassengerDetailsRQ\Structs\Customer
     */
    public function setID(\Sabre\PassengerDetailsRQ\Structs\ID $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get ReserveUnderName value
     * @return string[]|null
     */
    public function getReserveUnderName()
    {
        return $this->ReserveUnderName;
    }
    /**
     * Set ReserveUnderName value
     * @throws \InvalidArgumentException
     * @param string[] $reserveUnderName
     * @return \Sabre\PassengerDetailsRQ\Structs\Customer
     */
    public function setReserveUnderName(array $reserveUnderName = array())
    {
        $this->ReserveUnderName = $reserveUnderName;
        return $this;
    }
    /**
     * Add item to ReserveUnderName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\PassengerDetailsRQ\Structs\Customer
     */
    public function addToReserveUnderName($item)
    {
        $this->ReserveUnderName[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\Customer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
