<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckInCheckOutPolicy Structs
 * @subpackage Structs
 */
class CheckInCheckOutPolicy extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The CheckIn
     * Meta informations extracted from the WSDL
     * - documentation: The checkin time policy used to inform guest should check in after this check-in time. | A simple time type. Seconds can be omitted, since those values are not propagated to the Sabre backend systems. Accepted formats: "hh:mm:ss" or
     * "hh:mm"
     * - pattern: ([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $CheckIn;
    /**
     * The CheckOut
     * Meta informations extracted from the WSDL
     * - documentation: The checkout time policy used to inform that guest needs to check-out by this time | A simple time type. Seconds can be omitted, since those values are not propagated to the Sabre backend systems. Accepted formats: "hh:mm:ss" or
     * "hh:mm"
     * - pattern: ([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $CheckOut;
    /**
     * Constructor method for CheckInCheckOutPolicy
     * @uses CheckInCheckOutPolicy::set_()
     * @uses CheckInCheckOutPolicy::setCheckIn()
     * @uses CheckInCheckOutPolicy::setCheckOut()
     * @param string $_
     * @param string $checkIn
     * @param string $checkOut
     */
    public function __construct($_ = null, $checkIn = null, $checkOut = null)
    {
        $this
            ->set_($_)
            ->setCheckIn($checkIn)
            ->setCheckOut($checkOut);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\PassengerDetailsRQ\Structs\CheckInCheckOutPolicy
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get CheckIn value
     * @return string|null
     */
    public function getCheckIn()
    {
        return $this->CheckIn;
    }
    /**
     * Set CheckIn value
     * @param string $checkIn
     * @return \Sabre\PassengerDetailsRQ\Structs\CheckInCheckOutPolicy
     */
    public function setCheckIn($checkIn = null)
    {
        $this->CheckIn = $checkIn;
        return $this;
    }
    /**
     * Get CheckOut value
     * @return string|null
     */
    public function getCheckOut()
    {
        return $this->CheckOut;
    }
    /**
     * Set CheckOut value
     * @param string $checkOut
     * @return \Sabre\PassengerDetailsRQ\Structs\CheckInCheckOutPolicy
     */
    public function setCheckOut($checkOut = null)
    {
        $this->CheckOut = $checkOut;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\CheckInCheckOutPolicy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
