<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelPenalty Structs
 * @subpackage Structs
 */
class CancelPenalty extends AbstractStructBase
{
    /**
     * The PolicyCode
     * Meta informations extracted from the WSDL
     * - documentation: "PolicyCode" is used to return cancellation penalty information associated with the particular hotel reservation.
     * - use: optional
     * @var string
     */
    public $PolicyCode;
    /**
     * Constructor method for CancelPenalty
     * @uses CancelPenalty::setPolicyCode()
     * @param string $policyCode
     */
    public function __construct($policyCode = null)
    {
        $this
            ->setPolicyCode($policyCode);
    }
    /**
     * Get PolicyCode value
     * @return string|null
     */
    public function getPolicyCode()
    {
        return $this->PolicyCode;
    }
    /**
     * Set PolicyCode value
     * @param string $policyCode
     * @return \Sabre\PassengerDetailsRQ\Structs\CancelPenalty
     */
    public function setPolicyCode($policyCode = null)
    {
        $this->PolicyCode = $policyCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\CancelPenalty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
