<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Billing Structs
 * @subpackage Structs
 */
class Billing extends AbstractStructBase
{
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - documentation: "Number" is used to return the billing number.
     * - use: optional
     * @var string
     */
    public $Number;
    /**
     * The Reference
     * Meta informations extracted from the WSDL
     * - documentation: "Reference" is used to return the billing reference number.
     * - use: optional
     * @var string
     */
    public $Reference;
    /**
     * Constructor method for Billing
     * @uses Billing::setNumber()
     * @uses Billing::setReference()
     * @param string $number
     * @param string $reference
     */
    public function __construct($number = null, $reference = null)
    {
        $this
            ->setNumber($number)
            ->setReference($reference);
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \Sabre\PassengerDetailsRQ\Structs\Billing
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \Sabre\PassengerDetailsRQ\Structs\Billing
     */
    public function setReference($reference = null)
    {
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\Billing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
