<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssociatedPNRSummary Structs
 * @subpackage Structs
 */
class AssociatedPNRSummary extends AbstractStructBase
{
    /**
     * The RecordLocator
     * Meta informations extracted from the WSDL
     * - documentation: "RecordLocator" is used to return the Associated PNRs Record locator.
     * - minOccurs: 0
     * @var string
     */
    public $RecordLocator;
    /**
     * The NumberOfSeats
     * Meta informations extracted from the WSDL
     * - documentation: "NumberOfSeats" is used to return the number of seats in the Associated PNR.
     * - minOccurs: 0
     * @var string
     */
    public $NumberOfSeats;
    /**
     * The TicketingTimeLimitInfo
     * Meta informations extracted from the WSDL
     * - documentation: "TicketingTimeLimitInfo" is used to return the ticketing time limit for the Associated PNR.
     * - minOccurs: 0
     * @var string
     */
    public $TicketingTimeLimitInfo;
    /**
     * The FreeText
     * Meta informations extracted from the WSDL
     * - documentation: "FreeText" is used to return miscellaneous free text associated with the particular Associated PNR.
     * - minOccurs: 0
     * @var string
     */
    public $FreeText;
    /**
     * Constructor method for AssociatedPNRSummary
     * @uses AssociatedPNRSummary::setRecordLocator()
     * @uses AssociatedPNRSummary::setNumberOfSeats()
     * @uses AssociatedPNRSummary::setTicketingTimeLimitInfo()
     * @uses AssociatedPNRSummary::setFreeText()
     * @param string $recordLocator
     * @param string $numberOfSeats
     * @param string $ticketingTimeLimitInfo
     * @param string $freeText
     */
    public function __construct($recordLocator = null, $numberOfSeats = null, $ticketingTimeLimitInfo = null, $freeText = null)
    {
        $this
            ->setRecordLocator($recordLocator)
            ->setNumberOfSeats($numberOfSeats)
            ->setTicketingTimeLimitInfo($ticketingTimeLimitInfo)
            ->setFreeText($freeText);
    }
    /**
     * Get RecordLocator value
     * @return string|null
     */
    public function getRecordLocator()
    {
        return $this->RecordLocator;
    }
    /**
     * Set RecordLocator value
     * @param string $recordLocator
     * @return \Sabre\PassengerDetailsRQ\Structs\AssociatedPNRSummary
     */
    public function setRecordLocator($recordLocator = null)
    {
        $this->RecordLocator = $recordLocator;
        return $this;
    }
    /**
     * Get NumberOfSeats value
     * @return string|null
     */
    public function getNumberOfSeats()
    {
        return $this->NumberOfSeats;
    }
    /**
     * Set NumberOfSeats value
     * @param string $numberOfSeats
     * @return \Sabre\PassengerDetailsRQ\Structs\AssociatedPNRSummary
     */
    public function setNumberOfSeats($numberOfSeats = null)
    {
        $this->NumberOfSeats = $numberOfSeats;
        return $this;
    }
    /**
     * Get TicketingTimeLimitInfo value
     * @return string|null
     */
    public function getTicketingTimeLimitInfo()
    {
        return $this->TicketingTimeLimitInfo;
    }
    /**
     * Set TicketingTimeLimitInfo value
     * @param string $ticketingTimeLimitInfo
     * @return \Sabre\PassengerDetailsRQ\Structs\AssociatedPNRSummary
     */
    public function setTicketingTimeLimitInfo($ticketingTimeLimitInfo = null)
    {
        $this->TicketingTimeLimitInfo = $ticketingTimeLimitInfo;
        return $this;
    }
    /**
     * Get FreeText value
     * @return string|null
     */
    public function getFreeText()
    {
        return $this->FreeText;
    }
    /**
     * Set FreeText value
     * @param string $freeText
     * @return \Sabre\PassengerDetailsRQ\Structs\AssociatedPNRSummary
     */
    public function setFreeText($freeText = null)
    {
        $this->FreeText = $freeText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\AssociatedPNRSummary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
