<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Airline Structs
 * @subpackage Structs
 */
class Airline extends AbstractStructBase
{
    /**
     * The Hosted
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Hosted;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - documentation: Place holder for the Airline vendor code associated with the accounting line Example: Code="EY" | "Code" is used to return the airline associated with the particular SSR segment if applicable
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * Constructor method for Airline
     * @uses Airline::setHosted()
     * @uses Airline::setCode()
     * @param bool $hosted
     * @param string $code
     */
    public function __construct($hosted = null, $code = null)
    {
        $this
            ->setHosted($hosted)
            ->setCode($code);
    }
    /**
     * Get Hosted value
     * @return bool
     */
    public function getHosted()
    {
        return $this->Hosted;
    }
    /**
     * Set Hosted value
     * @param bool $hosted
     * @return \Sabre\PassengerDetailsRQ\Structs\Airline
     */
    public function setHosted($hosted = null)
    {
        $this->Hosted = $hosted;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\PassengerDetailsRQ\Structs\Airline
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\Airline
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
