<?php

namespace Sabre\PassengerDetailsRQ\Enums;

/**
 * This class stands for Type Enums
 * @subpackage Enumerations
 */
class Type
{
    /**
     * Constant for value 'INS'
     * @return string 'INS'
     */
    const VALUE_INS = 'INS';
    /**
     * Constant for value 'MCO'
     * @return string 'MCO'
     */
    const VALUE_MCO = 'MCO';
    /**
     * Constant for value 'OTH'
     * @return string 'OTH'
     */
    const VALUE_OTH = 'OTH';
    /**
     * Constant for value 'PTA'
     * @return string 'PTA'
     */
    const VALUE_PTA = 'PTA';
    /**
     * Constant for value 'Alpha-Coded'
     * @return string 'Alpha-Coded'
     */
    const VALUE_ALPHA_CODED = 'Alpha-Coded';
    /**
     * Constant for value 'Client Address'
     * @return string 'Client Address'
     */
    const VALUE_CLIENT_ADDRESS = 'Client Address';
    /**
     * Constant for value 'Corporate'
     * @return string 'Corporate'
     */
    const VALUE_CORPORATE = 'Corporate';
    /**
     * Constant for value 'Delivery Address'
     * @return string 'Delivery Address'
     */
    const VALUE_DELIVERY_ADDRESS = 'Delivery Address';
    /**
     * Constant for value 'General'
     * @return string 'General'
     */
    const VALUE_GENERAL = 'General';
    /**
     * Constant for value 'Group Name'
     * @return string 'Group Name'
     */
    const VALUE_GROUP_NAME = 'Group Name';
    /**
     * Constant for value 'Hidden'
     * @return string 'Hidden'
     */
    const VALUE_HIDDEN = 'Hidden';
    /**
     * Constant for value 'Historical'
     * @return string 'Historical'
     */
    const VALUE_HISTORICAL = 'Historical';
    /**
     * Constant for value 'Invoice'
     * @return string 'Invoice'
     */
    const VALUE_INVOICE = 'Invoice';
    /**
     * Constant for value 'Itinerary'
     * @return string 'Itinerary'
     */
    const VALUE_ITINERARY = 'Itinerary';
    /**
     * Constant for value 'BC'
     * @return string 'BC'
     */
    const VALUE_BC = 'BC';
    /**
     * Constant for value 'CC'
     * @return string 'CC'
     */
    const VALUE_CC = 'CC';
    /**
     * Constant for value 'FR'
     * @return string 'FR'
     */
    const VALUE_FR = 'FR';
    /**
     * Constant for value 'TO'
     * @return string 'TO'
     */
    const VALUE_TO = 'TO';
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The code
     * @var string
     */
    public $code;
    /**
     * The codeContext
     * @var string
     */
    public $codeContext;
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INS
     * @uses self::VALUE_MCO
     * @uses self::VALUE_OTH
     * @uses self::VALUE_PTA
     * @uses self::VALUE_ALPHA_CODED
     * @uses self::VALUE_CLIENT_ADDRESS
     * @uses self::VALUE_CORPORATE
     * @uses self::VALUE_DELIVERY_ADDRESS
     * @uses self::VALUE_GENERAL
     * @uses self::VALUE_GROUP_NAME
     * @uses self::VALUE_HIDDEN
     * @uses self::VALUE_HISTORICAL
     * @uses self::VALUE_INVOICE
     * @uses self::VALUE_ITINERARY
     * @uses self::VALUE_BC
     * @uses self::VALUE_CC
     * @uses self::VALUE_FR
     * @uses self::VALUE_TO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INS,
            self::VALUE_MCO,
            self::VALUE_OTH,
            self::VALUE_PTA,
            self::VALUE_ALPHA_CODED,
            self::VALUE_CLIENT_ADDRESS,
            self::VALUE_CORPORATE,
            self::VALUE_DELIVERY_ADDRESS,
            self::VALUE_GENERAL,
            self::VALUE_GROUP_NAME,
            self::VALUE_HIDDEN,
            self::VALUE_HISTORICAL,
            self::VALUE_INVOICE,
            self::VALUE_ITINERARY,
            self::VALUE_BC,
            self::VALUE_CC,
            self::VALUE_FR,
            self::VALUE_TO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
