<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Visa Structs
 * @subpackage Structs
 */
class Visa extends AbstractStructBase
{
    /**
     * The IssueDate
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: A full date type. Accepted format: "yyyy-mm-dd" | A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - pattern: \d{4}-\d{2}-\d{2} |
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $IssueDate;
    /**
     * The ApplicableCountry
     * @var string
     */
    public $ApplicableCountry;
    /**
     * The PlaceOfBirth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PlaceOfBirth;
    /**
     * The PlaceOfIssue
     * @var string
     */
    public $PlaceOfIssue;
    /**
     * Constructor method for Visa
     * @uses Visa::setIssueDate()
     * @uses Visa::setApplicableCountry()
     * @uses Visa::setPlaceOfBirth()
     * @uses Visa::setPlaceOfIssue()
     * @param string $issueDate
     * @param string $applicableCountry
     * @param string $placeOfBirth
     * @param string $placeOfIssue
     */
    public function __construct($issueDate = null, $applicableCountry = null, $placeOfBirth = null, $placeOfIssue = null)
    {
        $this
            ->setIssueDate($issueDate)
            ->setApplicableCountry($applicableCountry)
            ->setPlaceOfBirth($placeOfBirth)
            ->setPlaceOfIssue($placeOfIssue);
    }
    /**
     * Get IssueDate value
     * @return string
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param string $issueDate
     * @return \Sabre\CreatePassengerNameRecord\Structs\Visa
     */
    public function setIssueDate($issueDate = null)
    {
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get ApplicableCountry value
     * @return string|null
     */
    public function getApplicableCountry()
    {
        return $this->ApplicableCountry;
    }
    /**
     * Set ApplicableCountry value
     * @param string $applicableCountry
     * @return \Sabre\CreatePassengerNameRecord\Structs\Visa
     */
    public function setApplicableCountry($applicableCountry = null)
    {
        $this->ApplicableCountry = $applicableCountry;
        return $this;
    }
    /**
     * Get PlaceOfBirth value
     * @return string|null
     */
    public function getPlaceOfBirth()
    {
        return $this->PlaceOfBirth;
    }
    /**
     * Set PlaceOfBirth value
     * @param string $placeOfBirth
     * @return \Sabre\CreatePassengerNameRecord\Structs\Visa
     */
    public function setPlaceOfBirth($placeOfBirth = null)
    {
        $this->PlaceOfBirth = $placeOfBirth;
        return $this;
    }
    /**
     * Get PlaceOfIssue value
     * @return string|null
     */
    public function getPlaceOfIssue()
    {
        return $this->PlaceOfIssue;
    }
    /**
     * Set PlaceOfIssue value
     * @param string $placeOfIssue
     * @return \Sabre\CreatePassengerNameRecord\Structs\Visa
     */
    public function setPlaceOfIssue($placeOfIssue = null)
    {
        $this->PlaceOfIssue = $placeOfIssue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\Visa
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
