<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrivateFareInformation Structs
 * @subpackage Structs
 */
class PrivateFareInformation extends AbstractStructBase
{
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: "Text" is used to return the miscellaneous private fare-related information if applicable.
     * - maxOccurs: 7
     * - minOccurs: 0
     * @var string[]
     */
    public $Text;
    /**
     * The PrivateFareType
     * Meta informations extracted from the WSDL
     * - documentation: "PrivateFareType" is used to return the miscellaneous private fare-related information if applicable.
     * - use: optional
     * @var string
     */
    public $PrivateFareType;
    /**
     * The PrivateFareInd
     * Meta informations extracted from the WSDL
     * - documentation: "PrivateFareInd" is a private fare indicator.
     * - use: optional
     * @var bool
     */
    public $PrivateFareInd;
    /**
     * Constructor method for PrivateFareInformation
     * @uses PrivateFareInformation::setText()
     * @uses PrivateFareInformation::setPrivateFareType()
     * @uses PrivateFareInformation::setPrivateFareInd()
     * @param string[] $text
     * @param string $privateFareType
     * @param bool $privateFareInd
     */
    public function __construct(array $text = array(), $privateFareType = null, $privateFareInd = null)
    {
        $this
            ->setText($text)
            ->setPrivateFareType($privateFareType)
            ->setPrivateFareInd($privateFareInd);
    }
    /**
     * Get Text value
     * @return string[]|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @throws \InvalidArgumentException
     * @param string[] $text
     * @return \Sabre\CreatePassengerNameRecord\Structs\PrivateFareInformation
     */
    public function setText(array $text = array())
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Add item to Text value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\PrivateFareInformation
     */
    public function addToText($item)
    {
        $this->Text[] = $item;
        return $this;
    }
    /**
     * Get PrivateFareType value
     * @return string|null
     */
    public function getPrivateFareType()
    {
        return $this->PrivateFareType;
    }
    /**
     * Set PrivateFareType value
     * @param string $privateFareType
     * @return \Sabre\CreatePassengerNameRecord\Structs\PrivateFareInformation
     */
    public function setPrivateFareType($privateFareType = null)
    {
        $this->PrivateFareType = $privateFareType;
        return $this;
    }
    /**
     * Get PrivateFareInd value
     * @return bool|null
     */
    public function getPrivateFareInd()
    {
        return $this->PrivateFareInd;
    }
    /**
     * Set PrivateFareInd value
     * @param bool $privateFareInd
     * @return \Sabre\CreatePassengerNameRecord\Structs\PrivateFareInformation
     */
    public function setPrivateFareInd($privateFareInd = null)
    {
        $this->PrivateFareInd = $privateFareInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\PrivateFareInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
