<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentCard Structs
 * @subpackage Structs
 */
class PaymentCard extends AbstractStructBase
{
    /**
     * The ExpireDate
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: A type representing credit card expiration date. Accepted format: "yyyy-mm"
     * - pattern: \d{4}-\d{2}
     * @var int
     */
    public $ExpireDate;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - documentation: "Code" is used to return credit card code associated with the particular accounting line if applicable.
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The ExtendedPayment
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $ExtendedPayment;
    /**
     * The ManualApprovalCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ManualApprovalCode;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - documentation: "Number" is used to return credit card number associated with the particular accounting line if applicable.
     * - use: optional
     * @var int
     */
    public $Number;
    /**
     * The CardSecurityCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $CardSecurityCode;
    /**
     * The AirlineCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AirlineCode;
    /**
     * The SuppressApprovalCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $SuppressApprovalCode;
    /**
     * Constructor method for PaymentCard
     * @uses PaymentCard::setExpireDate()
     * @uses PaymentCard::setCode()
     * @uses PaymentCard::setExtendedPayment()
     * @uses PaymentCard::setManualApprovalCode()
     * @uses PaymentCard::setNumber()
     * @uses PaymentCard::setCardSecurityCode()
     * @uses PaymentCard::setAirlineCode()
     * @uses PaymentCard::setSuppressApprovalCode()
     * @param int $expireDate
     * @param string $code
     * @param int $extendedPayment
     * @param string $manualApprovalCode
     * @param int $number
     * @param int $cardSecurityCode
     * @param string $airlineCode
     * @param bool $suppressApprovalCode
     */
    public function __construct($expireDate = null, $code = null, $extendedPayment = null, $manualApprovalCode = null, $number = null, $cardSecurityCode = null, $airlineCode = null, $suppressApprovalCode = null)
    {
        $this
            ->setExpireDate($expireDate)
            ->setCode($code)
            ->setExtendedPayment($extendedPayment)
            ->setManualApprovalCode($manualApprovalCode)
            ->setNumber($number)
            ->setCardSecurityCode($cardSecurityCode)
            ->setAirlineCode($airlineCode)
            ->setSuppressApprovalCode($suppressApprovalCode);
    }
    /**
     * Get ExpireDate value
     * @return int
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param int $expireDate
     * @return \Sabre\CreatePassengerNameRecord\Structs\PaymentCard
     */
    public function setExpireDate($expireDate = null)
    {
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\CreatePassengerNameRecord\Structs\PaymentCard
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get ExtendedPayment value
     * @return int|null
     */
    public function getExtendedPayment()
    {
        return $this->ExtendedPayment;
    }
    /**
     * Set ExtendedPayment value
     * @param int $extendedPayment
     * @return \Sabre\CreatePassengerNameRecord\Structs\PaymentCard
     */
    public function setExtendedPayment($extendedPayment = null)
    {
        $this->ExtendedPayment = $extendedPayment;
        return $this;
    }
    /**
     * Get ManualApprovalCode value
     * @return string|null
     */
    public function getManualApprovalCode()
    {
        return $this->ManualApprovalCode;
    }
    /**
     * Set ManualApprovalCode value
     * @param string $manualApprovalCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\PaymentCard
     */
    public function setManualApprovalCode($manualApprovalCode = null)
    {
        $this->ManualApprovalCode = $manualApprovalCode;
        return $this;
    }
    /**
     * Get Number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \Sabre\CreatePassengerNameRecord\Structs\PaymentCard
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get CardSecurityCode value
     * @return int|null
     */
    public function getCardSecurityCode()
    {
        return $this->CardSecurityCode;
    }
    /**
     * Set CardSecurityCode value
     * @param int $cardSecurityCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\PaymentCard
     */
    public function setCardSecurityCode($cardSecurityCode = null)
    {
        $this->CardSecurityCode = $cardSecurityCode;
        return $this;
    }
    /**
     * Get AirlineCode value
     * @return string|null
     */
    public function getAirlineCode()
    {
        return $this->AirlineCode;
    }
    /**
     * Set AirlineCode value
     * @param string $airlineCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\PaymentCard
     */
    public function setAirlineCode($airlineCode = null)
    {
        $this->AirlineCode = $airlineCode;
        return $this;
    }
    /**
     * Get SuppressApprovalCode value
     * @return bool|null
     */
    public function getSuppressApprovalCode()
    {
        return $this->SuppressApprovalCode;
    }
    /**
     * Set SuppressApprovalCode value
     * @param bool $suppressApprovalCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\PaymentCard
     */
    public function setSuppressApprovalCode($suppressApprovalCode = null)
    {
        $this->SuppressApprovalCode = $suppressApprovalCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\PaymentCard
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
